/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client.renderer;

import erogenousbeef.bigreactors.client.ClientProxy;
import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.RotorBladeState;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import erogenousbeef.bigreactors.common.multiblock.helpers.RotorInfo;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBearing;
import erogenousbeef.bigreactors.init.BrBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;

public class RotorSpecialRenderer
extends TileEntitySpecialRenderer<TileEntityTurbineRotorBearing> {
    public void renderTileEntityAt(TileEntityTurbineRotorBearing bearing, double x, double y, double z, float partialTicks, int destroyStage) {
        MultiblockTurbine turbine = bearing.getTurbine();
        RotorInfo rotorInfo = bearing.getRotorInfo();
        if (null == rotorInfo || null == turbine || !turbine.isAssembledAndActive() || turbine.isInteriorInvisible()) {
            return;
        }
        float angle = RotorSpecialRenderer.getRotorAngle(bearing, turbine);
        int dX = rotorInfo.rotorDirection.func_82601_c();
        int dY = rotorInfo.rotorDirection.func_96559_d();
        int dZ = rotorInfo.rotorDirection.func_82599_e();
        float rotationOffsetX = 0 == dX ? 0.5f : 0.0f;
        float rotationOffsetY = 0 == dY ? 0.5f : 0.0f;
        float rotationOffsetZ = 0 == dZ ? 0.5f : 0.0f;
        Integer displayList = bearing.getDisplayList();
        if (displayList == null) {
            float brightness = bearing.func_145831_w().func_175724_o(bearing.func_174877_v().func_177972_a(rotorInfo.rotorDirection));
            displayList = RotorSpecialRenderer.generateRotor(rotorInfo, brightness);
            bearing.setDisplayList(displayList);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x += (double)dX), (double)(y += (double)dY), (double)(z += (double)dZ));
        GlStateManager.func_179109_b((float)rotationOffsetX, (float)rotationOffsetY, (float)rotationOffsetZ);
        GlStateManager.func_179114_b((float)angle, (float)dX, (float)dY, (float)dZ);
        GlStateManager.func_179109_b((float)(-rotationOffsetX), (float)(-rotationOffsetY), (float)(-rotationOffsetZ));
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179148_o((int)displayList);
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TileEntityTurbineRotorBearing te) {
        return true;
    }

    private static float getRotorAngle(TileEntityTurbineRotorBearing bearing, MultiblockTurbine turbine) {
        long elapsedTime = Minecraft.func_71386_F() - ClientProxy.lastRenderTime;
        float speed = turbine.getRotorSpeed() / 10.0f;
        float angle = bearing.getAngle();
        if (speed > 0.001f) {
            angle += speed * ((float)elapsedTime / 60000.0f) * 360.0f;
            bearing.setAngle(angle %= 360.0f);
        }
        return angle;
    }

    private static int generateRotor(RotorInfo info, float brightness) {
        int list = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)list, (int)4864);
        RotorSpecialRenderer.renderRotor(info, brightness);
        GlStateManager.func_187415_K();
        return list;
    }

    private static void renderRotor(RotorInfo info, float brightness) {
        BlockRendererDispatcher renderer = Minecraft.func_71410_x().func_175602_ab();
        IBlockState defaultShaftState = BrBlocks.turbineRotorShaft.func_176223_P();
        EnumFacing[] bladeDirections = RotorShaftState.getBladesDirections(info.rotorDirection.func_176740_k());
        int dX = info.rotorDirection.func_82601_c();
        int dY = info.rotorDirection.func_96559_d();
        int dZ = info.rotorDirection.func_82599_e();
        for (int shaftIdx = 0; shaftIdx < info.rotorLength; ++shaftIdx) {
            IBlockState shaftState = defaultShaftState.func_177226_a(Properties.ROTORSHAFTSTATE, (Comparable)((Object)info.shaftStates[shaftIdx]));
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(dX * shaftIdx), (float)(dY * shaftIdx), (float)(dZ * shaftIdx));
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(shaftState, brightness);
            GlStateManager.func_179121_F();
            int[] currentBladeLengths = info.bladeLengths[shaftIdx];
            RotorBladeState[] currentBladeStates = info.bladeStates[shaftIdx];
            for (int bladeIdx = 0; bladeIdx < bladeDirections.length; ++bladeIdx) {
                int bladeLength = currentBladeLengths[bladeIdx];
                RotorBladeState bladeState = currentBladeStates[bladeIdx];
                if (bladeLength <= 0 || null == bladeState) continue;
                RotorSpecialRenderer.renderRotorBlade2b(bladeDirections[bladeIdx], bladeLength, bladeState, dX * shaftIdx, dY * shaftIdx, dZ * shaftIdx, renderer, brightness);
            }
        }
    }

    private static void renderRotorBlade2b(EnumFacing bladeDir, int bladeLength, RotorBladeState bladeState, int shaftOffsetX, int shaftOffsetY, int shaftOffsetZ, BlockRendererDispatcher renderer, float brightness) {
        IBlockState blockState = BrBlocks.turbineRotorBlade.func_176223_P().func_177226_a(Properties.ROTORBLADESTATE, (Comparable)((Object)bladeState));
        int dX = bladeDir.func_82601_c();
        int dY = bladeDir.func_96559_d();
        int dZ = bladeDir.func_82599_e();
        for (int bladeIdx = 0; bladeIdx < bladeLength; ++bladeIdx) {
            int offsetX = shaftOffsetX + dX * (bladeIdx + 1);
            int offsetY = shaftOffsetY + dY * (bladeIdx + 1);
            int offsetZ = shaftOffsetZ + dZ * (bladeIdx + 1);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)offsetX, (float)offsetY, (float)offsetZ);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderer.func_175016_a(blockState, brightness);
            GlStateManager.func_179121_F();
        }
    }
}

