/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBaseDirectional;

public class TileEntityVaultTank
extends TileEntityVaultBaseDirectional
implements net.minecraftforge.fluids.IFluidHandler {
    public final FluidTank tank = new FluidTank(16000);
    private String displaydata = "";

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        NBTTagCompound nbtCompound = new NBTTagCompound();
        this.tank.writeToNBT(nbtCompound);
        nbtTag.func_74782_a("Tank", (NBTBase)nbtCompound);
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        NBTTagCompound nbtCompound = nbtTag.func_74775_l("Tank");
        this.tank.readFromNBT(nbtCompound);
    }

    public void buildNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SyncOnly(nbtTag);
        if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0) {
            nbtTag.func_74778_a("displaydata", this.tank.getFluid().amount + "mB - ^%" + this.tank.getFluid().getUnlocalizedName() + "%");
        }
    }

    public void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        super.processNBT_SyncOnly(nbtTag);
        if (nbtTag.func_74764_b("displaydata")) {
            String[] parts = nbtTag.func_74779_i("displaydata").split("\\^");
            if (parts.length == 2 && parts[1].length() > 2 && parts[1].startsWith("%") & parts[1].endsWith("%")) {
                parts[1] = Localization.get((String)parts[1].substring(1, parts[1].length() - 1));
                this.displaydata = parts[0] + parts[1];
            }
        } else {
            this.displaydata = null;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            TileEntity oTile;
            if (facing != null && (oTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()))) != null && oTile.hasCapability(capability, facing)) {
                return (T)oTile.getCapability(capability, facing);
            }
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int fill = this.tank.fill(resource, doFill);
        if (doFill && fill > 0) {
            Function.syncTile((TileEntity)this);
        }
        return fill;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack drain = this.tank.drain(maxDrain, doDrain);
        if (doDrain && drain != null && drain.amount > 0) {
            Function.syncTile((TileEntity)this);
        }
        return drain;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.getFluid() == null || this.tank.getFluid().getFluid().getName().equals(fluid.getName());
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tank.getFluid() != null && this.tank.getFluid().getFluid().getName().equals(fluid.getName());
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    protected boolean isEmpty() {
        return this.tank.getFluidAmount() < 1;
    }

    @Override
    protected void tryTransfer(TileEntity tile) {
        IFluidHandler handler;
        if (tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d()) && (handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d())) != null) {
            this.tank.drain(handler.fill(this.tank.getFluid(), true), true);
        }
    }

    @Override
    public List<String> getExtraHudInfo(List<String> info, boolean isWaila) {
        if (isWaila) {
            info.add(Localization.get((String)"hud.msg.stored") + " " + Localization.get((String)"hud.msg.fluid"));
            if (Strings.isNullOrEmpty((String)this.displaydata)) {
                info.add(Localization.get((String)"hud.msg.empty"));
            } else {
                info.add(this.displaydata);
            }
        }
        return info;
    }
}

