/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.tileentity;

import com.google.common.base.Strings;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.inventory.ContainerEnderLink;

public class TileEntityEnderLinkChest
extends TileEntityBase
implements ITickable,
IInventory,
IRGB16_Tile {
    private String code = "000";
    private String ownerID = null;
    private String owner = "all";
    private ItemStack personalItem;
    public boolean rayTracing = false;
    public int tracePart = 0;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;

    public void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("code", this.getCode());
        nbtTag.func_74778_a("owner", this.owner);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            nbtTag.func_74778_a("ownerID", this.ownerID);
        }
        if (this.personalItem != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.personalItem.func_77955_b(compound);
            nbtTag.func_74782_a("PersonalUpgrade", (NBTBase)compound);
        }
    }

    public void processNBT(NBTTagCompound nbtTag) {
        this.setCode(nbtTag.func_74779_i("code"));
        this.owner = nbtTag.func_74779_i("owner");
        if (nbtTag.func_74764_b("ownerID")) {
            this.ownerID = nbtTag.func_74779_i("ownerID");
        }
        if (nbtTag.func_74764_b("PersonalUpgrade")) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("PersonalUpgrade"));
            if (stack != null && stack.field_77994_a != 1) {
                stack.field_77994_a = 1;
            }
            this.personalItem = stack;
        }
    }

    public void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
    }

    public void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            try {
                UUID uuid = UUID.fromString(this.getOwnerID());
                if (UsernameCache.containsUUID((UUID)uuid)) {
                    this.owner = UsernameCache.getLastKnownUsername((UUID)uuid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean hasFastRenderer() {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    public void func_73660_a() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.func_145831_w().field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + x + y + z) % 200 == 0) {
            this.numPlayersUsing = 0;
            for (EntityPlayer player : this.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                if (!(player.field_71070_bA instanceof ContainerEnderLink) || !((ContainerEnderLink)player.field_71070_bA).isParentTile(this)) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.075f) : (this.lidAngle -= 0.075f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.func_145831_w().func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int value) {
        if (id == 1) {
            this.numPlayersUsing = value;
            return true;
        }
        return super.func_145842_c(id, value);
    }

    public boolean isOpen() {
        return this.numPlayersUsing > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.canBeAutomated() || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.canBeAutomated()) {
            return (T)new InvWrapper(this.getChest());
        }
        return (T)super.getCapability(capability, side);
    }

    private boolean canBeAutomated() {
        return this.isPublic() ? Settings.INSTANCE.enableAutomationPublic : (this.isTeam() ? Settings.INSTANCE.enableAutomationTeam : Settings.INSTANCE.enableAutomationPersonal);
    }

    public IInventory getChest() {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode());
    }

    public int func_70302_i_() {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        return !this.canBeAutomated() ? null : ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70298_a(slotId, amount);
    }

    public ItemStack func_70304_b(int slotId) {
        return !this.canBeAutomated() ? null : ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        if (this.canBeAutomated()) {
            ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70299_a(slotId, stack);
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        if (!player.func_175149_v()) {
            ++this.numPlayersUsing;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numPlayersUsing);
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numPlayersUsing);
            this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q());
        }
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_174885_b(id, value);
    }

    public int func_174890_g() {
        return ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_174890_g();
    }

    public void func_174888_l() {
        ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_174888_l();
    }

    public String func_70005_c_() {
        return "EnderChest: " + ChestHelper.getChest(this.func_145831_w(), this.getOwnerID(), this.getCode()).func_70005_c_();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean canEdit(EntityPlayer player) {
        boolean canEdit = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canEdit = !Settings.INSTANCE.lockTeamEdit || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (!this.isPublic()) {
                canEdit = !Settings.INSTANCE.lockPersonalEdit || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canEdit && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage.chest." + msg);
        }
        return canEdit;
    }

    public boolean canUse(EntityPlayer player) {
        boolean canUse = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                canUse = !Settings.INSTANCE.lockTeamUse || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                msg = "team.denied";
            } else if (this.isPublic()) {
                canUse = Settings.INSTANCE.allowPublicChests;
                msg = "public.disabled";
            } else {
                canUse = !Settings.INSTANCE.lockPersonalUse || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                msg = "private.denied";
            }
        }
        if (!canUse && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage.chest." + msg);
        }
        return canUse;
    }

    public boolean canLink(EntityPlayer player) {
        boolean canLink = true;
        String msg = "";
        if (!player.field_71075_bZ.field_75098_d) {
            if (this.isTeam()) {
                if (Settings.INSTANCE.allowTeamBags) {
                    canLink = !Settings.INSTANCE.lockTeamLink || this.ownerID.equalsIgnoreCase(this.getPlayerTeam(player));
                    msg = "chest.team.denied";
                } else {
                    canLink = false;
                    msg = "bag.team.disabled";
                }
            } else if (!this.isPublic()) {
                if (Settings.INSTANCE.allowPersonalBags) {
                    canLink = !Settings.INSTANCE.lockPersonalLink || !Strings.isNullOrEmpty((String)this.ownerID) && this.ownerID.equals(player.func_110124_au().toString());
                    msg = "chest.private.denied";
                } else {
                    canLink = false;
                    msg = "bag.private.disabled";
                }
            }
        }
        if (!canLink && !Strings.isNullOrEmpty((String)msg)) {
            ChestInfoHelper.sendError(player, "multistorage." + msg);
        }
        return canLink;
    }

    private String getPlayerTeam(EntityPlayer player) {
        String team = Function.getPlayerTeamID((EntityPlayer)player);
        return "#" + (Strings.isNullOrEmpty((String)team) ? "none" : team);
    }

    public String getOwnerID() {
        if (this.owner.equalsIgnoreCase("all")) {
            return "all";
        }
        if (!Strings.isNullOrEmpty((String)this.ownerID)) {
            return this.ownerID;
        }
        return this.owner;
    }

    public String getOwnerName() {
        return ChestInfoHelper.getDisplayNameFromOwnerID(this.ownerID);
    }

    public void setOwner(EntityPlayer player, ItemStack stack) {
        this.personalItem = stack;
        this.owner = player.getDisplayNameString();
        this.ownerID = player.func_110124_au().toString();
    }

    public void setOwner(String ownerName, String ownerID, ItemStack stack) {
        if (ownerID != null) {
            this.personalItem = stack;
            this.owner = ownerName;
            this.ownerID = ownerID;
        }
    }

    public ItemStack getPersonalItem() {
        if (this.personalItem != null) {
            if (this.personalItem.field_77994_a != 1) {
                this.personalItem.field_77994_a = 1;
            }
            return this.personalItem;
        }
        return null;
    }

    public boolean isPublic() {
        return this.owner.equalsIgnoreCase("all");
    }

    public boolean isTeam() {
        return this.ownerID != null && this.ownerID.startsWith("#");
    }

    public String getCode() {
        while (this.code.length() < 3) {
            this.code = "0" + this.code;
        }
        return this.code.toUpperCase();
    }

    public void setCode(String code) {
        while (code.length() < 3) {
            code = "0" + code;
        }
        this.code = code.toUpperCase();
    }

    public boolean hasError() {
        return !this.isPublic() && Strings.isNullOrEmpty((String)this.ownerID);
    }

    public RGB16 getRGB16(EntityPlayer player) {
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return null;
        }
        int value = Integer.parseInt("" + this.getCode().charAt(ring), 16);
        return new RGB16(EnumDyeColor.func_176764_b((int)value).func_176610_l());
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        return this.doColorRing(EnumDyeColor.func_176764_b((int)RGB16Helper.getSimpleColor((short)rgbIndex)), player);
    }

    public boolean doColorRing(EnumDyeColor color, EntityPlayer player) {
        if (!this.canEdit(player)) {
            return false;
        }
        int ring = this.getRingHit(player);
        if (ring < 0) {
            return false;
        }
        char charColor = Integer.toHexString(color.func_176765_a()).charAt(0);
        char[] charCode = this.getCode().toCharArray();
        if (charCode[ring] != charColor) {
            charCode[ring] = charColor;
            this.setCode("" + charCode[0] + charCode[1] + charCode[2]);
            Function.syncTile((TileEntity)this);
            return true;
        }
        return false;
    }

    private int getRingHit(EntityPlayer player) {
        Function.BlockInfo info = Function.getBlockInfront((World)this.func_145831_w(), (EntityPlayer)player, (double)5.0);
        if (info == null || info.sub < 1 || info.sub > 3) {
            return -1;
        }
        return info.sub - 1;
    }
}

