/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemMulti;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.enderlink.StackHelper;
import shetiphian.multistorage.common.inventory.ContainerEnderLink;
import shetiphian.multistorage.common.inventory.ContainerEnderPocket;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

public class ItemEnderBag
extends ItemMulti
implements IColored {
    public ItemEnderBag() {
        super("ItemEnderBag", Values.nameMapper);
        this.field_77777_bU = 1;
        this.func_77637_a((CreativeTabs)Values.tabMultiStorage);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (Settings.INSTANCE.enableEnderLinkBag) {
            for (String code : StackHelper.BASECODES) {
                list.add(StackHelper.create(item, code, null));
            }
        }
        list.add(new ItemStack((Item)this, 1, 2));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (stack.func_77952_i() == 2) {
            if (Settings.INSTANCE.enableEnderBag) {
                stack.func_77964_b(stack.func_77952_i() + 10);
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                player.openGui((Object)MultiStorage.INSTANCE, 6, world, player.field_70176_ah, player.field_70162_ai, player.field_70164_aj);
            }
        } else if (Settings.INSTANCE.enableEnderLinkBag) {
            BlockPos pos;
            boolean isSneaking = player.func_70093_af();
            RayTraceResult mop = this.func_77621_a(world, player, !isSneaking);
            BlockPos blockPos = pos = mop != null ? mop.func_178782_a() : null;
            if (isSneaking && pos != null && world.func_180495_p(pos).func_177230_c() == Values.blockEnderLinkChest) {
                TileEntityEnderLinkChest chestTile = (TileEntityEnderLinkChest)world.func_175625_s(pos);
                if (chestTile.hasError()) {
                    if (!world.field_72995_K) {
                        ChestInfoHelper.sendLinkError(player, 2);
                    }
                } else {
                    if (chestTile.canLink(player)) {
                        return new ActionResult(EnumActionResult.SUCCESS, (Object)StackHelper.create((Item)this, chestTile.getCode(), chestTile.getOwnerID()));
                    }
                    if (!world.field_72995_K) {
                        ChestInfoHelper.sendLinkError(player, chestTile.isTeam() ? 3 : 1);
                    }
                }
            }
            if (stack.func_77952_i() != 0 || Settings.INSTANCE.allowPublicBags) {
                ChestHelper.setWantedChest(player, StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), StackHelper.getCode(stack));
                stack.func_77964_b(stack.func_77952_i() + 10);
                player.func_184185_a(SoundEvents.field_187719_p, 1.0f, 1.0f);
                player.openGui((Object)MultiStorage.INSTANCE, 8, world, player.field_70176_ah, player.field_70162_ai, player.field_70164_aj);
            } else {
                ChestInfoHelper.sendError(player, "multistorage.bag.public.disabled");
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Container container;
        if (stack.func_77952_i() < 10) {
            return;
        }
        if (isSelected && entity instanceof EntityPlayer && ((container = ((EntityPlayer)entity).field_71070_bA) instanceof ContainerEnderLink || container instanceof ContainerEnderPocket)) {
            return;
        }
        stack.func_77964_b(stack.func_77952_i() - 10);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        if (stack.func_77952_i() == 2) {
            if (!Settings.INSTANCE.enableEnderBag) {
                tooltip.add("\u00a7o" + Localization.get((String)"info.multistorage.craftingmaterial.txt"));
            }
        } else if (stack.func_77952_i() < 4) {
            tooltip.add(" " + Localization.get((String)"info.multistorage.chest.code.txt") + " " + StackHelper.getCode(stack));
            String owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack), false);
            if (!Strings.isNullOrEmpty((String)owner)) {
                tooltip.add(owner);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && data.stack != null && data.stack.func_77952_i() % 10 < 2) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Settings.INSTANCE.colorValues[value];
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "", "enderbag_public", "public");
        this.add(1, "", "enderbag_private", "private");
        this.add(2, "", "enderbag_personal", "personal");
        this.add(3, "", "enderbag_team", "team");
        this.add(10, "", "enderbag_public_open", "public");
        this.add(11, "", "enderbag_private_open", "private");
        this.add(12, "", "enderbag_personal_open", "personal");
        this.add(13, "", "enderbag_team_open", "team");
    }
}

