/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.inventory;

import java.util.ArrayDeque;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.inventory.InventoryShifted;
import shetiphian.multistorage.common.tileentity.TileEntityQueue;

public class InventoryQueue
extends InventoryInternal {
    private ArrayDeque<ItemStack> stackQueue = new ArrayDeque();
    private final TileEntityQueue invOwner;

    public InventoryQueue(TileEntityQueue invOwner, int stacksize) {
        super((TileEntity)invOwner, "internal", 4, stacksize, "inv.queue");
        this.invOwner = invOwner;
    }

    public void writeToNBT(NBTTagCompound nbtTag, String name) {
        super.writeToNBT(nbtTag, name);
        NBTTagList listStacks = new NBTTagList();
        for (ItemStack stack : this.stackQueue) {
            if (stack == null) continue;
            NBTTagCompound entry = new NBTTagCompound();
            stack.func_77955_b(entry);
            listStacks.func_74742_a((NBTBase)entry);
        }
        nbtTag.func_74782_a("stackQueue", (NBTBase)listStacks);
    }

    public void readFromNBT(NBTTagCompound nbtTag, String name) {
        super.readFromNBT(nbtTag, name);
        this.stackQueue.clear();
        NBTTagList listStacks = nbtTag.func_150295_c("stackQueue", 10);
        for (int index = 0; index < listStacks.func_74745_c(); index = (int)((short)(index + 1))) {
            NBTTagCompound entry = listStacks.func_150305_b(index);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)entry);
            if (stack == null) continue;
            this.stackQueue.addLast(stack);
        }
        this.refresh();
    }

    public boolean isFull() {
        return this.stackQueue.size() >= 4096;
    }

    public float getFillPercentage() {
        return this.stackQueue.size() / 4096;
    }

    public ItemStack[] getContents() {
        ItemStack[] queue = this.stackQueue.toArray(new ItemStack[0]);
        ItemStack[] allContents = new ItemStack[queue.length + 2];
        allContents[0] = this.contents[0];
        System.arraycopy(queue, 0, allContents, 1, queue.length);
        allContents[queue.length + 1] = this.contents[2];
        return allContents;
    }

    public void func_70296_d() {
        this.refresh();
        super.func_70296_d();
    }

    public void refresh() {
        if (this.contents[1] == null) {
            this.stackQueue.pollFirst();
        }
        if (this.contents[3] == null) {
            this.stackQueue.pollLast();
        }
        this.processInput(0, 1, true);
        this.processInput(2, 3, false);
        this.populateOutput(1, true);
        this.populateOutput(3, false);
        List<ITextComponent> lines = this.invOwner.getListQueueDisplay();
        lines.clear();
        for (ItemStack stack : this.stackQueue) {
            if (stack == null) continue;
            lines.add((ITextComponent)new TextComponentString(stack.field_77994_a + "x " + stack.func_82833_r()));
        }
    }

    private void processInput(int input, int output, boolean head) {
        if (this.contents[input] != null) {
            if (this.contents[output] != null && Function.areItemStacksEqual((ItemStack)this.contents[output], (ItemStack)this.contents[input])) {
                this.mergeStacks(this.contents[input], this.contents[output]);
            }
            if (this.contents[input] != null) {
                if (head) {
                    this.stackQueue.addFirst(this.contents[input]);
                } else {
                    this.stackQueue.addLast(this.contents[input]);
                }
                this.contents[input] = null;
            }
        }
        this.contents[output] = null;
    }

    private void mergeStacks(ItemStack stack, ItemStack itemstack) {
        int j = itemstack.field_77994_a + stack.field_77994_a;
        int maxSize = Math.min(this.func_70297_j_(), stack.func_77976_d());
        if (j <= maxSize) {
            stack.field_77994_a = 0;
            itemstack.field_77994_a = j;
        } else if (itemstack.field_77994_a < maxSize) {
            stack.field_77994_a -= maxSize - itemstack.field_77994_a;
            itemstack.field_77994_a = maxSize;
        }
    }

    private void populateOutput(int output, boolean head) {
        if (!this.stackQueue.isEmpty()) {
            ItemStack stack;
            ItemStack itemStack = stack = head ? this.stackQueue.peekFirst() : this.stackQueue.peekLast();
            if (stack != null) {
                this.contents[output] = stack;
            }
        }
    }

    public InvWrapper getWrapperHIO() {
        return new WrapperBasic((IInventory)new InventoryHead((IInventory)this));
    }

    public InvWrapper getWrapperHI() {
        return new WrapperInput((IInventory)new InventoryHead((IInventory)this));
    }

    public InvWrapper getWrapperHO() {
        return new WrapperOutput((IInventory)new InventoryHead((IInventory)this));
    }

    public InvWrapper getWrapperTIO() {
        return new WrapperBasic((IInventory)new InventoryTail((IInventory)this));
    }

    public InvWrapper getWrapperTI() {
        return new WrapperInput((IInventory)new InventoryTail((IInventory)this));
    }

    public InvWrapper getWrapperTO() {
        return new WrapperOutput((IInventory)new InventoryTail((IInventory)this));
    }

    private class InventoryTail
    extends InventoryShiftedWithParent {
        private InventoryTail(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId % 2 + 2;
        }

        public int func_70302_i_() {
            return 2;
        }

        public String func_70005_c_() {
            return "inv.queue.tail";
        }
    }

    private class InventoryHead
    extends InventoryShiftedWithParent {
        private InventoryHead(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId % 2;
        }

        public int func_70302_i_() {
            return 2;
        }

        public String func_70005_c_() {
            return "inv.queue.head";
        }
    }

    private abstract class InventoryShiftedWithParent
    extends InventoryShifted {
        InventoryShiftedWithParent(IInventory parent) {
            super(parent);
        }

        public IInventory getParent() {
            return this.parent;
        }
    }

    private class WrapperOutput
    extends WrapperBasic {
        private WrapperOutput(IInventory inv) {
            super(inv);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    }

    private class WrapperInput
    extends WrapperBasic {
        private WrapperInput(IInventory inv) {
            super(inv);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }
    }

    private class WrapperBasic
    extends InvWrapper {
        private WrapperBasic(IInventory inv) {
            super(inv);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot % 2 == 1 || this.isFull()) {
                return stack;
            }
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (result == null) {
                this.syncTile();
            }
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot % 2 == 0) {
                return null;
            }
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (result != null) {
                this.syncTile();
            }
            return result;
        }

        private InventoryQueue getRootParent() {
            IInventory inventory;
            if (this.getInv() instanceof InventoryShiftedWithParent && (inventory = ((InventoryShiftedWithParent)this.getInv()).getParent()) instanceof InventoryQueue) {
                return (InventoryQueue)inventory;
            }
            return null;
        }

        private boolean isFull() {
            InventoryQueue rootParent = this.getRootParent();
            return rootParent == null || rootParent.isFull();
        }

        private void syncTile() {
            InventoryQueue rootParent = this.getRootParent();
            if (rootParent != null) {
                Function.syncTile((TileEntity)rootParent.invOwner);
            }
        }
    }
}

