/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.UsernameCache;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

public class ChestInfoHelper {
    private static final ChestInfoHelper INSTANCE = new ChestInfoHelper();
    private static final Cache<String, String> NAMECACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public static void wailaGetTankInfo(List<String> tooltip, TileEntityEnderLinkChest tile) {
        if (tile == null) {
            return;
        }
        tooltip.add(ChestInfoHelper.formatChestOwner(tile.getOwnerName(), true));
    }

    public static void sendCapacityInfo(EntityPlayer player, TileEntityEnderLinkChest tankTile) {
        String message = INSTANCE.localize("info.multistorage.chest.capacity.txt");
        message = message + " " + ChestHelper.getCapacity(player.field_70170_p, tankTile.getOwnerID(), tankTile.getCode());
        INSTANCE.sendInfo(player, message);
    }

    public static void sendLinkError(EntityPlayer player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.multistorage.bag.nolink" + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(EntityPlayer player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static String formatChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + INSTANCE.localize("info.multistorage.chest.public.txt") + "-]\u00a7r" : "";
        }
        String color = !Strings.isNullOrEmpty((String)owner) && owner.startsWith("#") ? "a" : "b";
        return " \u00a7" + color + "[-" + owner + "-]\u00a7r";
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            message = message.replace("<br>", " ");
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentString(message), 2));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.func_146105_b((ITextComponent)new TextComponentString(line));
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        String ownerName = (String)NAMECACHE.getIfPresent((Object)ownerID);
        if (Strings.isNullOrEmpty((String)ownerName)) {
            if (ownerID.startsWith("#")) {
                ownerName = Function.getTeamDisplayName((String)ownerID.substring(1));
            } else if (!ownerID.equals("all")) {
                try {
                    UUID uuid = UUID.fromString(ownerID);
                    if (UsernameCache.containsUUID((UUID)uuid)) {
                        ownerName = Strings.nullToEmpty((String)UsernameCache.getLastKnownUsername((UUID)uuid));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            NAMECACHE.put((Object)ownerID, (Object)(Strings.isNullOrEmpty((String)ownerName) ? ownerID : ownerName));
        }
        return ownerName;
    }
}

