/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.enderlink;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.common.enderlink.ChestHelper;

class ChestData
extends InventoryInternal {
    private byte capacity = (byte)9;

    ChestData(String owner, String code) {
        super(null, "", 54, 64, owner.toLowerCase() + "." + code.toLowerCase());
    }

    void setCapacity(byte capacity) {
        this.capacity = (byte)MathHelper.func_76125_a((int)capacity, (int)Settings.INSTANCE.chestSizeMin, (int)Settings.INSTANCE.chestSizeMax);
        ChestHelper.needsSaving = true;
    }

    NBTTagCompound saveToNBT(NBTTagCompound nbtTag) {
        NBTTagList nbtList = new NBTTagList();
        for (int index = 0; index < this.contents.length; ++index) {
            if (this.contents[index] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a("Slot", (byte)index);
            this.contents[index].func_77955_b(nbtCompound);
            nbtList.func_74742_a((NBTBase)nbtCompound);
        }
        nbtTag.func_74782_a("Items", (NBTBase)nbtList);
        nbtTag.func_74774_a("Capacity", this.capacity);
        return nbtTag;
    }

    ChestData loadFromNBT(NBTTagCompound nbtTag) {
        this.setCapacity(nbtTag.func_74771_c("Capacity"));
        NBTTagList nbtList = nbtTag.func_150295_c("Items", 10);
        for (int index = 0; index < nbtList.func_74745_c(); ++index) {
            NBTTagCompound nbtCompound = nbtList.func_150305_b(index);
            int slot = nbtCompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.contents.length) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
        }
        return this;
    }

    boolean saveCheck() {
        if (this.capacity > Settings.INSTANCE.chestSizeMin) {
            return true;
        }
        for (ItemStack content : this.contents) {
            if (content == null) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return MathHelper.func_76125_a((int)this.capacity, (int)Settings.INSTANCE.chestSizeMin, (int)Settings.INSTANCE.chestSizeMax);
    }

    public void func_70296_d() {
        ChestHelper.needsSaving = true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }
}

