/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;
import shetiphian.multistorage.common.tileentity.TileEntityJunkboxDense;

class TypeJunkbox
implements IStorageType {
    private static final AxisAlignedBB AABB_LOWER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_UPPER = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    TypeJunkbox() {
    }

    private TileEntityJunkbox getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityJunkbox ? (TileEntityJunkbox)tile : null;
    }

    @Override
    public TileEntity createTileEntity(boolean dense) {
        return dense ? new TileEntityJunkboxDense() : new TileEntityJunkbox();
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityJunkbox tile = this.getTile(world, pos);
        if (tile != null) {
            BlockStorageType.EnumType type = tile instanceof TileEntityJunkboxDense ? (tile.isDouble() ? BlockStorageType.EnumType.DENSE_JUNKBOX_DOUBLE : (tile.isTop() ? BlockStorageType.EnumType.DENSE_JUNKBOX_TOP : BlockStorageType.EnumType.DENSE_JUNKBOX_BOTTOM)) : (tile.isDouble() ? BlockStorageType.EnumType.JUNKBOX_DOUBLE : (tile.isTop() ? BlockStorageType.EnumType.JUNKBOX_TOP : BlockStorageType.EnumType.JUNKBOX_BOTTOM));
            state = state.func_177226_a(BlockStorageType.VARIANT, (Comparable)((Object)type));
        }
        return state;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public AxisAlignedBB getBoxBounds(BlockStorageType block, IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityJunkbox tile = this.getTile(world, pos);
        if (tile != null && !tile.isDouble()) {
            return tile.isTop() ? AABB_UPPER : AABB_LOWER;
        }
        return Block.field_185505_j;
    }

    @Override
    public boolean addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        return false;
    }

    @Override
    public float getBlockHardness(IBlockState state, World world, BlockPos pos, float original) {
        return original;
    }

    @Override
    public void onBlockPlaced(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityJunkbox tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.setFacing(player.func_174811_aO().func_176734_d());
            tile.setTop(side == EnumFacing.DOWN || side != EnumFacing.UP && hitY > 0.5f);
        }
    }

    @Override
    public void onBlockRemoved(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    public void getDrops(List<ItemStack> ret, Block block, BlockStorageType.EnumType type) {
        if (type == BlockStorageType.EnumType.JUNKBOX_DOUBLE) {
            ret.add(new ItemStack(block, 2, 5));
        } else if (type == BlockStorageType.EnumType.DENSE_JUNKBOX_DOUBLE) {
            ret.add(new ItemStack(block, 1, 6));
            ret.add(new ItemStack(block, 1, 5));
        } else {
            ret.add(new ItemStack(block, 1, 5 + (type.isDense() ? 1 : 0)));
        }
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)MultiStorage.INSTANCE, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityJunkbox tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.setFacing(tile.getFacing().func_176746_e());
            Function.syncTile((TileEntity)tile);
            return true;
        }
        return false;
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess world, BlockPos pos, int renderPass) {
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getPickBlock(RayTraceResult target, World world, BlockPos pos, EntityPlayer player, Block block, BlockStorageType.EnumType type) {
        return new ItemStack(block, 1, 5 + (type.isDense() ? 1 : 0));
    }
}

