/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.IColored;
import shetiphian.core.common.block.properties.UnlistedNBTProperty;
import shetiphian.core.common.block.properties.UnlistedPropertyIBlockState;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.block.TypeChameleon;
import shetiphian.multistorage.common.block.TypeDefaults;
import shetiphian.multistorage.common.block.TypeJunkbox;
import shetiphian.multistorage.common.block.TypeQueue;
import shetiphian.multistorage.common.block.TypeStacking;
import shetiphian.multistorage.common.tileentity.TileEntityQueue;
import shetiphian.multistorage.common.tileentity.TileEntityStorageBase;

public abstract class BlockStorageType
extends Block
implements IColored {
    private static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final IStorageType DEFAULTS = new TypeDefaults();
    public static final IStorageType STACKING = new TypeStacking();
    public static final IStorageType CHAMELEON = new TypeChameleon();
    public static final IStorageType JUNKBOX = new TypeJunkbox();
    public static final IStorageType QUEUE = new TypeQueue();
    public static final UnlistedPropertyIBlockState EIBS = UnlistedPropertyIBlockState.create((String)"eibs");
    public static final UnlistedNBTProperty DATA = UnlistedNBTProperty.create((String)"data");

    public BlockStorageType(Material material) {
        super(material);
        this.field_149783_u = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT, FACING}, new IUnlistedProperty[]{EIBS, DATA});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() != this) {
            return EnumType.CHAMELEON.getValue();
        }
        return BlockStorageType.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityStorageBase tile = this.getTile(world, pos);
        if (tile != null) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)tile.getFacing());
        }
        return BlockStorageType.getHelper(state).getActualState(state, world, pos);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockStorageType.getHelper(state).getExtendedState(state, world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return BlockStorageType.getHelper(state).createTileEntity(BlockStorageType.getEnumType(state).isDense());
    }

    private TileEntityStorageBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityStorageBase ? (TileEntityStorageBase)tile : null;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return super.canHarvestBlock(world, pos, player);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockStorageType.getHelper(state).getBoxBounds(this, state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        if (!BlockStorageType.getHelper(state).addCollisionBoxesToList(world, pos, state, aabb, list, entity)) {
            super.func_185477_a(state, world, pos, aabb, list, entity);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return BlockStorageType.getHelper(state).getBlockHardness(state, world, pos, super.func_176195_g(state, world, pos));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityStorageBase) {
            ((TileEntityStorageBase)tile).dropItems();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockStorageType.getHelper(state).onBlockRemoved(world, pos, player);
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (world.func_180495_p(pos).func_177230_c() == this) {
            state = this.func_176221_a(state, world, pos);
        }
        BlockStorageType.getHelper(state).getDrops(ret, this, BlockStorageType.getEnumType(state));
        return ret;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumType type = null;
        switch (meta) {
            case 1: {
                type = EnumType.STACKABLE_SINGLE;
                break;
            }
            case 2: {
                type = EnumType.DENSE_STACKABLE_SINGLE;
                break;
            }
            case 3: {
                type = EnumType.CHAMELEON;
                break;
            }
            case 4: {
                type = EnumType.DENSE_CHAMELEON;
                break;
            }
            case 5: {
                type = EnumType.JUNKBOX_BOTTOM;
                break;
            }
            case 6: {
                type = EnumType.DENSE_JUNKBOX_BOTTOM;
                break;
            }
            case 7: {
                type = EnumType.QUEUE;
                break;
            }
            case 8: {
                type = EnumType.DENSE_QUEUE;
            }
        }
        if (type == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return BlockStorageType.getHelper(state).isSideSolid(world, pos, side);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return BlockStorageType.getHelper(state).onBlockActivated(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        boolean powered;
        TileEntityStorageBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile instanceof TileEntityQueue && (powered = world.func_175640_z(pos)) != ((TileEntityQueue)tile).triggered) {
            ((TileEntityQueue)tile).triggered = powered;
            world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        }
        super.func_189540_a(state, world, pos, block);
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntityStorageBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile instanceof TileEntityQueue) {
            ((TileEntityQueue)tile).updateTick();
        }
        super.func_180650_b(world, pos, state, rand);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return BlockStorageType.getHelper(world.func_180495_p(pos)).rotateBlock(world, pos, axis);
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return BlockStorageType.getHelper(world.func_180495_p(pos)).getEnchantPowerBonus(world, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockStorageType.getHelper(state).getLightValue(world, pos);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return BlockStorageType.getHelper(state).getLightOpacity(world, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return BlockStorageType.getHelper(state).canRenderInLayer(state, layer);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (data.state != null && data.world != null && data.pos != null) {
            return BlockStorageType.getHelper(data.state).colorMultiplier(data.world, data.pos, index);
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockStorageType.getHelper(state).getPickBlock(target, world, pos, player, this, BlockStorageType.getEnumType(state));
    }

    private static IStorageType getHelper(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStorageType) {
            switch (BlockStorageType.getEnumType(state)) {
                case STACKABLE_SINGLE: 
                case STACKABLE_TOP: 
                case STACKABLE_MIDDLE: 
                case STACKABLE_BOTTOM: 
                case DENSE_STACKABLE_SINGLE: 
                case DENSE_STACKABLE_TOP: 
                case DENSE_STACKABLE_MIDDLE: 
                case DENSE_STACKABLE_BOTTOM: {
                    return STACKING;
                }
                case CHAMELEON: 
                case DENSE_CHAMELEON: {
                    return CHAMELEON;
                }
                case JUNKBOX_TOP: 
                case JUNKBOX_BOTTOM: 
                case JUNKBOX_DOUBLE: 
                case DENSE_JUNKBOX_TOP: 
                case DENSE_JUNKBOX_BOTTOM: 
                case DENSE_JUNKBOX_DOUBLE: {
                    return JUNKBOX;
                }
                case QUEUE: 
                case DENSE_QUEUE: {
                    return QUEUE;
                }
            }
        }
        return DEFAULTS;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.STACKABLE_SINGLE;
            MultiStorage.errorPropertyNotFound("BlockStorageType.VARIANT", "STACKABLE_SINGLE", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        STACKABLE_SINGLE(0, false),
        STACKABLE_TOP(1, false),
        STACKABLE_MIDDLE(2, false),
        STACKABLE_BOTTOM(3, false),
        CHAMELEON(4, false),
        JUNKBOX_TOP(5, false),
        JUNKBOX_BOTTOM(5, false),
        JUNKBOX_DOUBLE(5, false),
        QUEUE(6, false),
        DENSE_STACKABLE_SINGLE(8, true),
        DENSE_STACKABLE_TOP(9, true),
        DENSE_STACKABLE_MIDDLE(10, true),
        DENSE_STACKABLE_BOTTOM(11, true),
        DENSE_CHAMELEON(12, true),
        DENSE_JUNKBOX_TOP(13, true),
        DENSE_JUNKBOX_BOTTOM(13, true),
        DENSE_JUNKBOX_DOUBLE(13, true),
        DENSE_QUEUE(14, true);

        private static final EnumType[] array;
        private final byte value;
        private final boolean dense;

        private EnumType(int value, boolean dense) {
            this.value = (byte)value;
            this.dense = dense;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? STACKABLE_SINGLE : type;
        }

        public boolean isDense() {
            return this.dense;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] != null) continue;
                EnumType.array[value.getValue()] = value;
            }
        }
    }
}

