/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.enderlink.StackHelper;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

public class BlockEnderLinkChest
extends Block
implements IColored {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.00625, 0.00625, 0.00625, 0.99375, 0.99375, 0.99375);
    private static final AxisAlignedBB AABB_LID_D = new AxisAlignedBB(0.00625, 1.5, 0.00625, 0.99375, 1.7, 0.99375);
    private static final AxisAlignedBB AABB_LID_U = new AxisAlignedBB(0.00625, -0.7, 0.00625, 0.99375, -0.5, 0.99375);
    private static final AxisAlignedBB AABB_LID_N = new AxisAlignedBB(0.00625, 0.00625, 1.5, 0.99375, 0.99375, 1.7);
    private static final AxisAlignedBB AABB_LID_S = new AxisAlignedBB(0.00625, 0.00625, -0.7, 0.99375, 0.99375, -0.5);
    private static final AxisAlignedBB AABB_LID_W = new AxisAlignedBB(1.5, 0.00625, 0.00625, 1.7, 0.99375, 0.99375);
    private static final AxisAlignedBB AABB_LID_E = new AxisAlignedBB(-0.7, 0.00625, 0.00625, -0.5, 0.99375, 0.99375);
    private final float[] size = new float[]{0.001f, 0.999f};
    private final float[][] ring = new float[][]{{0.73125f, 0.79375f}, {0.65625f, 0.71875f}, {0.58125f, 0.64375f}};

    public BlockEnderLinkChest() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabMultiStorage);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT, Properties.StaticProperty});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta > 5 ? 0 : meta));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return BlockEnderLinkChest.getFacing(state).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(true));
        TileEntityEnderLinkChest tile = this.getTile(world, pos);
        if (tile != null) {
            return state.func_177226_a(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : (tile.isPublic() ? EnumType.PUBLIC : EnumType.PRIVATE))));
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEnderLinkChest();
    }

    private TileEntityEnderLinkChest getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityEnderLinkChest ? (TileEntityEnderLinkChest)tile : null;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return AABB_BASE;
        }
        return this.getTraceBox(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        TileEntityEnderLinkChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.isOpen()) {
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)this.getBounds(state, true));
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)aabb, list, (AxisAlignedBB)this.getBounds(state, false));
    }

    private AxisAlignedBB getBounds(IBlockState state, boolean lid) {
        if (lid) {
            EnumFacing facing = BlockEnderLinkChest.getFacing(state);
            switch (facing) {
                case DOWN: {
                    return AABB_LID_D;
                }
                case UP: {
                    return AABB_LID_U;
                }
                case NORTH: {
                    return AABB_LID_N;
                }
                case SOUTH: {
                    return AABB_LID_S;
                }
                case WEST: {
                    return AABB_LID_W;
                }
                case EAST: {
                    return AABB_LID_E;
                }
            }
        }
        return AABB_BASE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityEnderLinkChest chestTile = this.getTile((IBlockAccess)world, pos);
        if (chestTile == null) {
            return false;
        }
        if (!player.func_70093_af()) {
            if (chestTile.canUse(player) && world.func_175623_d(pos.func_177972_a(BlockEnderLinkChest.getFacing(state).func_176734_d()))) {
                player.openGui((Object)MultiStorage.INSTANCE, 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null) {
            byte by;
            if (world.field_72995_K) {
                return true;
            }
            if (chestTile.isPublic()) {
                boolean changed = false;
                for (ItemStack itemStack : Settings.INSTANCE.itemPersonal) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)itemStack)) continue;
                    if (Settings.INSTANCE.allowPersonalChests) {
                        chestTile.setOwner(player, currentItem.func_77946_l().func_77979_a(1));
                        changed = true;
                        break;
                    }
                    ChestInfoHelper.sendError(player, "multistorage.chest.private.disabled");
                    break;
                }
                if (!changed) {
                    for (ItemStack itemStack : Settings.INSTANCE.itemTeam) {
                        if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)itemStack)) continue;
                        if (Settings.INSTANCE.allowTeamChests) {
                            String teamID = Function.getPlayerTeamID((EntityPlayer)player);
                            if (!Strings.isNullOrEmpty((String)teamID)) {
                                chestTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.func_77946_l().func_77979_a(1));
                                changed = true;
                                break;
                            }
                            ChestInfoHelper.sendError(player, "shetiphian.team.noteam");
                            return true;
                        }
                        ChestInfoHelper.sendError(player, "multistorage.chest.team.disabled");
                        break;
                    }
                }
                if (changed) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    Function.syncTile((TileEntity)chestTile);
                    return true;
                }
            }
            if (!chestTile.canEdit(player)) {
                return true;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < Settings.INSTANCE.chestSizeMax) {
                int newValue = 0;
                for (ItemStack stack : Settings.INSTANCE.itemSCapacityUpgrade) {
                    if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                    newValue = 3;
                    break;
                }
                if (newValue == 0 && capacity + 9 <= Settings.INSTANCE.chestSizeMax) {
                    for (ItemStack stack : Settings.INSTANCE.itemLCapacityUpgrade) {
                        if (!Function.areItemStacksEqual((ItemStack)currentItem, (ItemStack)stack)) continue;
                        newValue = 9;
                        break;
                    }
                }
                if (newValue > 0) {
                    ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --currentItem.field_77994_a;
                    }
                    ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    return true;
                }
            }
            boolean found = false;
            boolean bl = false;
            block4: while (by < 16) {
                List results = Function.getOres((String)Function.dyeNamesWB[by]);
                for (ItemStack check : results) {
                    if (!OreDictionary.itemMatches((ItemStack)currentItem, (ItemStack)check, (boolean)true)) continue;
                    found = true;
                    break block4;
                }
                by = (byte)(by + true);
            }
            if (found && chestTile.doColorRing(EnumDyeColor.func_176764_b((int)by), player)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --currentItem.field_77994_a;
                }
                return true;
            }
        }
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityEnderLinkChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.func_180647_a(state, player, world, pos) == -1.0f) {
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        super.removedByPlayer(state, world, pos, player, true);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityEnderLinkChest tile = this.getTile(world, pos);
        if (tile != null) {
            if (this.harvesters.get() != null && ((EntityPlayer)this.harvesters.get()).func_70093_af()) {
                ret.add(StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null));
                ItemStack personal = tile.getPersonalItem();
                if (personal != null) {
                    ret.add(personal);
                }
            } else {
                ret.add(StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem()));
            }
        } else {
            ret.add(new ItemStack((Block)this));
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityEnderLinkChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            if (player != null && !player.func_70093_af()) {
                if (tile.isTeam() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((EntityPlayer)player)))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase(player.func_110124_au().toString()))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null);
        }
        return new ItemStack((Block)this);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing facing = BlockEnderLinkChest.getFacing(world.func_180495_p(pos));
        if (axis.func_176740_k() == facing.func_176740_k()) {
            return false;
        }
        EnumFacing newFacing = facing.func_176732_a(axis.func_176740_k());
        if (facing != newFacing) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)newFacing), (boolean)true);
            return true;
        }
        return false;
    }

    private AxisAlignedBB getTraceBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityEnderLinkChest tile = this.getTile(world, pos);
        if (tile == null || !tile.rayTracing || tile.tracePart < 1 || tile.tracePart > 4) {
            return this.getBounds(state, false);
        }
        int index = tile.tracePart - 1;
        EnumFacing facing = BlockEnderLinkChest.getFacing(state);
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)this.size[0], (double)this.ring[index][0], (double)this.size[0], (double)this.size[1], (double)this.ring[index][1], (double)this.size[1]);
            }
            case UP: {
                return new AxisAlignedBB((double)this.size[0], (double)this.ring[2 - index][0] - 0.375, (double)this.size[0], (double)this.size[1], (double)this.ring[2 - index][1] - 0.375, (double)this.size[1]);
            }
            case NORTH: {
                return new AxisAlignedBB((double)this.size[0], (double)this.size[0], (double)this.ring[index][0], (double)this.size[1], (double)this.size[1], (double)this.ring[index][1]);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)this.size[0], (double)this.size[0], (double)this.ring[2 - index][0] - 0.375, (double)this.size[1], (double)this.size[1], (double)this.ring[2 - index][1] - 0.375);
            }
            case WEST: {
                return new AxisAlignedBB((double)this.ring[index][0], (double)this.size[0], (double)this.size[0], (double)this.ring[index][1], (double)this.size[1], (double)this.size[1]);
            }
            case EAST: {
                return new AxisAlignedBB((double)this.ring[2 - index][0] - 0.375, (double)this.size[0], (double)this.size[0], (double)this.ring[2 - index][1] - 0.375, (double)this.size[1], (double)this.size[1]);
            }
        }
        return this.getBounds(state, false);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        this.getBounds(state, false);
        RayTraceResult original = super.func_180636_a(state, world, pos, startVec, endVec);
        TileEntityEnderLinkChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            RayTraceResult areaHit = null;
            tile.rayTracing = true;
            double hitDist = 100.0;
            for (int codeBand = 0; codeBand < 4; codeBand = (int)((byte)(codeBand + 1))) {
                tile.tracePart = codeBand;
                RayTraceResult ringHit = this.func_185503_a(pos, startVec, endVec, this.getTraceBox((IBlockAccess)world, pos, state));
                if (ringHit == null) continue;
                ringHit.subHit = codeBand;
                double ringDist = ringHit.field_72307_f.func_72436_e(startVec);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = ringHit;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                tile.tracePart = areaHit.subHit;
                return areaHit;
            }
            tile.rayTracing = false;
        }
        return original;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderLinkChest tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile(data.world, data.pos)) != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Settings.INSTANCE.colorValues[value];
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityEnderLinkChest tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.isOpen()) {
            for (int particle = 0; particle < 3; ++particle) {
                double shift = (double)rand.nextInt(2) * 2.0 - 1.0;
                double xCoord = (double)pos.func_177958_n() + 0.5 + 0.25 * shift;
                double yCoord = (double)pos.func_177956_o() + rand.nextDouble() + 0.5;
                double zCoord = (double)pos.func_177952_p() + 0.5 + 0.25 * shift;
                double xOffset = rand.nextDouble() * shift;
                double yOffset = (rand.nextDouble() - 0.5) * 0.125;
                double zOffset = rand.nextDouble() * shift;
                world.func_175688_a(EnumParticleTypes.PORTAL, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, new int[0]);
            }
        }
    }

    public static EnumFacing getFacing(IBlockState state) {
        EnumFacing facing;
        try {
            facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        catch (Exception e) {
            facing = EnumFacing.DOWN;
            Values.logMultiStorage.error("PropertyEnum 'BlockEnderLinkChest.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static enum EnumType implements IStringSerializable
    {
        PUBLIC,
        PRIVATE,
        TEAM;


        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

