/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.renderer;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.core.client.ClientFunction;
import shetiphian.core.common.item.NameMapper;
import shetiphian.core.forgefixes.OBJLoader;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.client.model.CustomModelLoader;
import shetiphian.multistorage.client.model.ModelChameleon;
import shetiphian.multistorage.client.renderer.RenderCorer;
import shetiphian.multistorage.client.renderer.RenderEnderChest;
import shetiphian.multistorage.client.renderer.RenderStackingChest;
import shetiphian.multistorage.common.misc.FluidConcrete;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;

public class RenderRegistry {
    private static RenderRegistry INSTANCE = new RenderRegistry();

    public static void renderingPreInt() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        OBJLoader.INSTANCE.addDomain("multistorage");
        INSTANCE.registerCustomStateMappers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CustomModelLoader());
        INSTANCE.registerItemModels();
        INSTANCE.registerEntityRendering();
        INSTANCE.registerTileEntityRendering();
    }

    public static void renderingInt() {
        INSTANCE.registerColorize();
    }

    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(FluidConcrete.resource);
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        if (Values.blockCloudStorage != null) {
            this.setChameleon(event, new ModelResourceLocation("multistorage:cloud_storage#facing=north,variant=chameleon"));
            this.setChameleon(event, new ModelResourceLocation("multistorage:cloud_storage#facing=north,variant=dense_chameleon"));
        }
        if (Values.blockStoneStorage != null) {
            this.setChameleon(event, new ModelResourceLocation("multistorage:stone_storage#facing=north,variant=chameleon"));
            this.setChameleon(event, new ModelResourceLocation("multistorage:stone_storage#facing=north,variant=dense_chameleon"));
        }
    }

    private void setChameleon(ModelBakeEvent event, ModelResourceLocation resource) {
        Object object = event.getModelRegistry().func_82594_a((Object)resource);
        if (object != null) {
            IBakedModel base = (IBakedModel)object;
            ModelChameleon model = new ModelChameleon(base);
            event.getModelRegistry().func_82595_a((Object)resource, (Object)model);
        }
    }

    private void registerCustomStateMappers() {
        StateMapperBase mapper;
        if (Values.blockCloudStorage != null) {
            mapper = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    String property = this.func_178131_a((Map)state.func_177228_b());
                    if (property.contains("chameleon")) {
                        property = property.replaceFirst("(?<=facing=)(.*?)(?=[-\\W])", "north");
                    }
                    return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), property);
                }
            };
            ModelLoader.setCustomStateMapper((Block)Values.blockCloudStorage, (IStateMapper)mapper);
        }
        if (Values.blockStoneStorage != null) {
            mapper = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    String property = this.func_178131_a((Map)state.func_177228_b());
                    if (property.contains("chameleon")) {
                        property = property.replaceFirst("(?<=facing=)(.*?)(?=[-\\W])", "north");
                    }
                    return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), property);
                }
            };
            ModelLoader.setCustomStateMapper((Block)Values.blockStoneStorage, (IStateMapper)mapper);
        }
    }

    private void registerItemModels() {
        this.registerItemModels(Values.blockCloudStorage, "BlockCloudStorage");
        this.registerItemModels(Values.blockStoneStorage, "BlockStoneStorage");
        this.registerItemModels(Values.blockEnderLinkChest, "BlockEnderLinkChest");
        this.registerItemModels(Values.blockVault, "BlockVault");
        this.registerItemModels(Values.itemEnderBag, "ItemEnderBag");
    }

    private void registerItemModels(Block block, String key) {
        if (block != null) {
            this.registerItemModels(Item.func_150898_a((Block)block), key);
        }
    }

    private void registerItemModels(Item item, String key) {
        if (item != null) {
            for (Map.Entry entry : Values.nameMapper.getAllDataFor(key).entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)entry.getKey()), (ModelResourceLocation)((NameMapper.NameData)entry.getValue()).getResource());
            }
        }
    }

    private void registerEntityRendering() {
    }

    private void registerTileEntityRendering() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnderLinkChest.class, (TileEntitySpecialRenderer)new RenderEnderChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStackingChest.class, (TileEntitySpecialRenderer)new RenderStackingChest());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityVaultCorer.class, (TileEntitySpecialRenderer)new RenderCorer());
    }

    private void registerColorize() {
        ClientFunction.registerColorize((Block)Values.blockCloudStorage);
        ClientFunction.registerColorize((Block)Values.blockEnderLinkChest);
        ClientFunction.registerColorize((Block)Values.blockStoneStorage);
        ClientFunction.registerColorize((Block)Values.blockVault);
        ClientFunction.registerColorize((Item)Values.itemEnderBag);
    }
}

