/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.gui;

import java.io.IOException;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.multistorage.client.gui.GuiContainer;
import shetiphian.multistorage.common.inventory.ContainerStacking;
import shetiphian.multistorage.common.inventory.SlotHideable;

@SideOnly(value=Side.CLIENT)
public class GuiStacking
extends GuiContainer {
    private static final ResourceLocation textureGUIStackingCloud = new ResourceLocation("multistorage", "textures/gui/stacking_cloud.png");
    private static final ResourceLocation textureGUIStackingStone = new ResourceLocation("multistorage", "textures/gui/stacking_stone.png");
    private boolean isCloud;
    private int slotCount;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public GuiStacking(ContainerStacking chest, boolean isCloud) {
        super(chest);
        this.isCloud = isCloud;
        this.field_146291_p = false;
        this.slotCount = 0;
        if (chest != null) {
            this.slotCount = chest.field_75151_b.size() - 36;
        }
        this.field_147000_g = this.slotCount < 28 ? 177 : 233;
        this.field_146999_f = 201;
        this.moveSlots();
    }

    private void moveSlots() {
        int position = (int)((double)(this.currentScroll * (float)((this.slotCount + 8) / 9 - 6)) + 0.5);
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (!(invSlot instanceof SlotHideable)) continue;
            SlotHideable slot = (SlotHideable)invSlot;
            int group = slot.getSlotIndex() - position * 9;
            if (group < 0 || group > 53) {
                slot.setVisible(false);
                continue;
            }
            slot.setVisible(true);
            slot.field_75223_e = 20 + group % 9 * 18;
            slot.field_75221_f = 18 + group / 9 * 18;
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.field_146297_k.func_110434_K().func_110577_a(this.isCloud ? textureGUIStackingCloud : textureGUIStackingStone);
        int winLeft = (this.field_146294_l - this.field_146999_f) / 2 + 9;
        int winTop = (this.field_146295_m - this.field_147000_g) / 2 + 7;
        int ypos = 0;
        if (this.slotCount < 28) {
            this.func_73729_b(winLeft, winTop + ypos, 0, 30, 182, 64);
            this.func_73729_b(winLeft, winTop + (ypos += 64), 0, 148, 182, 10);
            ypos += 10;
        } else {
            boolean scroll = this.slotCount > 54;
            this.func_73729_b(winLeft, winTop + ypos, 0, 30, scroll ? 172 : 182, 128);
            if (scroll) {
                this.func_73729_b(winLeft + 172, winTop + ypos, 182, 30, 28, 128);
                int i = this.field_147003_i + 186;
                int j = this.field_147009_r + 18;
                int k = j + 108;
                this.func_73729_b(i, j + (int)((float)(k - j - 17) * this.currentScroll), 244, 241, 12, 15);
            }
            ypos += 128;
        }
        this.func_73729_b(winLeft, winTop + ypos, 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.slotCount > 54) {
            int j = this.slotCount / 9 - 6;
            i = MathHelper.func_76125_a((int)i, (int)-1, (int)1);
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.moveSlots();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean flag = Mouse.isButtonDown((int)0);
        int k = this.field_147003_i + 184;
        int l = this.field_147009_r + 17;
        int i1 = k + 14;
        int j1 = l + 108;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            boolean bl = this.isScrolling = this.slotCount > 54;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.moveSlots();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146977_a(Slot slot) {
        if (slot.func_111238_b()) {
            super.func_146977_a(slot);
        }
    }

    @Override
    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return slot.func_111238_b() && super.func_146981_a(slot, mouseX, mouseY);
    }
}

