/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.GuiFunctions;
import shetiphian.core.client.Localization;
import shetiphian.multistorage.client.gui.GuiContainer;
import shetiphian.multistorage.common.inventory.ContainerJunkbox;
import shetiphian.multistorage.common.inventory.SlotHideable;
import shetiphian.multistorage.common.tileentity.TileEntityJunkbox;

@SideOnly(value=Side.CLIENT)
public class GuiJunkbox
extends GuiContainer {
    private static final ResourceLocation textureCloud = new ResourceLocation("multistorage", "textures/gui/junkbox_cloud.png");
    private static final ResourceLocation textureStone = new ResourceLocation("multistorage", "textures/gui/junkbox_stone.png");
    private boolean isCloud;
    private TileEntityJunkbox chestTile;
    private ContainerJunkbox container;
    private Map<Integer, Byte> slotOrder = new HashMap<Integer, Byte>();

    public GuiJunkbox(EntityPlayer player, TileEntityJunkbox tile, boolean isCloud) {
        super(new ContainerJunkbox(player, tile));
        this.isCloud = isCloud;
        this.chestTile = tile;
        this.container = (ContainerJunkbox)this.field_147002_h;
        this.field_146999_f = 182;
        this.field_147000_g = 190;
        this.setLayout();
    }

    private void setLayout() {
        this.slotOrder.clear();
        ArrayList<Integer> usedSlots = new ArrayList<Integer>();
        ArrayList freeSlots = new ArrayList();
        for (int slotId = 0; slotId < this.chestTile.getChestSize(); ++slotId) {
            (this.chestTile.getChest().func_70301_a(slotId) != null ? usedSlots : freeSlots).add(slotId);
        }
        for (byte slot = 0; slot < 16; slot = (byte)(slot + 1)) {
            if (usedSlots.isEmpty()) {
                this.slotOrder.put((Integer)freeSlots.get(0), slot);
                freeSlots.remove(0);
                continue;
            }
            int pick = this.chestTile.func_145831_w().field_73012_v.nextInt(usedSlots.size());
            this.slotOrder.put((Integer)usedSlots.get(pick), slot);
            usedSlots.remove(pick);
        }
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            SlotHideable slot;
            if (!(invSlot instanceof SlotHideable)) continue;
            int slotId = (slot = (SlotHideable)invSlot).getSlotIndex();
            this.moveSlot(slot, this.slotOrder.containsKey(slotId) ? (int)this.slotOrder.get(slotId).byteValue() : -1);
        }
    }

    private void moveSlot(SlotHideable slot, int guiSlot) {
        if (guiSlot < 0 || guiSlot > 15) {
            slot.setVisible(false);
        } else {
            slot.setVisible(true);
            slot.field_75223_e = 56 + guiSlot % 4 * 18;
            slot.field_75221_f = 11 + guiSlot / 4 * 18;
        }
    }

    private void rerollSlot(SlotHideable slot) {
        int pick;
        int index = slot.getSlotIndex();
        if (!this.slotOrder.containsKey(index)) {
            return;
        }
        byte guiSlot = this.slotOrder.get(index);
        this.slotOrder.remove(index);
        this.moveSlot(slot, -1);
        ArrayList<Integer> hiddenUsedSlots = new ArrayList<Integer>();
        ArrayList<Integer> hiddenFreeSlots = new ArrayList<Integer>();
        for (int slotId = 0; slotId < this.chestTile.getChestSize(); ++slotId) {
            if (this.slotOrder.containsKey(slotId)) continue;
            if (this.chestTile.getChest().func_70301_a(slotId) == null) {
                hiddenFreeSlots.add(slotId);
                continue;
            }
            if (this.slotOrder.containsKey(slotId)) continue;
            hiddenUsedSlots.add(slotId);
        }
        if (hiddenUsedSlots.isEmpty()) {
            pick = this.chestTile.func_145831_w().field_73012_v.nextInt(hiddenFreeSlots.size());
            this.slotOrder.put((Integer)hiddenFreeSlots.get(pick), guiSlot);
            index = (Integer)hiddenFreeSlots.get(pick);
        } else {
            pick = this.chestTile.func_145831_w().field_73012_v.nextInt(hiddenUsedSlots.size());
            this.slotOrder.put((Integer)hiddenUsedSlots.get(pick), guiSlot);
            index = (Integer)hiddenUsedSlots.get(pick);
        }
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (!(invSlot instanceof SlotHideable) || invSlot.getSlotIndex() != index) continue;
            this.moveSlot((SlotHideable)invSlot, guiSlot);
            return;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.isHovered(mouseX, mouseY, 135, 64, 17, 17)) {
            this.setLayout();
            this.slotOrder.size();
        }
    }

    @Override
    protected void func_184098_a(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        boolean reroll = slot != null && slot.func_75216_d();
        super.func_184098_a(slot, slotId, clickedButton, clickType);
        if (slot != null) {
            if (slot instanceof SlotHideable) {
                if (reroll) {
                    this.rerollSlot((SlotHideable)slot);
                }
            } else if (GuiJunkbox.func_146272_n() && slot.func_75216_d()) {
                this.setLayout();
            }
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.field_146297_k.func_110434_K().func_110577_a(this.isCloud ? textureCloud : textureStone);
        int winLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int winTop = (this.field_146295_m - this.field_147000_g) / 2;
        int ypos = 0;
        this.func_73729_b(winLeft + 20, winTop + ypos, 20, 66, 144, 92);
        this.func_73729_b(winLeft, winTop + (ypos += 92), 0, 158, 182, 98);
        GuiFunctions.drawTextureScaled((double)(winLeft + 30), (double)(winTop + 10), (int)208, (int)224, (int)16, (int)16, (double)0.5, (float)1.0f, (int[])new int[0]);
        GuiFunctions.drawTextureScaled((double)(winLeft + 41), (double)(winTop + 10), (int)208, (int)240, (int)16, (int)16, (double)0.5, (float)1.0f, (int[])new int[0]);
        int progress = (int)((double)this.container.usedSpace[0] / (double)this.container.usedSpace[1] * 61.0);
        this.func_73729_b(winLeft + 30, winTop + 82 - progress, 224, 256 - progress, 8, progress);
        progress = (int)((double)this.container.usedSlots / (double)this.chestTile.getChestSize() * 61.0);
        this.func_73729_b(winLeft + 41, winTop + 82 - progress, 232, 256 - progress, 8, progress);
        this.func_73729_b(winLeft + 30, winTop + 21, 240, 195, 8, 61);
        this.func_73729_b(winLeft + 41, winTop + 21, 248, 195, 8, 61);
        this.func_73729_b(winLeft + 136, winTop + 65, 192, this.isHovered(mouseX, mouseY, 135, 64, 17, 17) ? 240 : 224, 16, 16);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ArrayList<String> text = new ArrayList<String>();
        if (this.isHovered(mouseX, mouseY, 30, 10, 8, 8)) {
            text.add(Localization.get((String)"gui.multistorage.junkbox.usedspace.txt"));
            Localization.multiLine((String)"gui.multistorage.junkbox.usedspace.msg", text);
        } else if (this.isHovered(mouseX, mouseY, 41, 10, 8, 8)) {
            text.add(Localization.get((String)"gui.multistorage.junkbox.usedslots.txt"));
            Localization.multiLine((String)"gui.multistorage.junkbox.usedslots.msg", text);
        } else if (this.isHovered(mouseX, mouseY, 30, 21, 8, 61)) {
            text.add(Localization.get((String)"gui.multistorage.junkbox.usedspace.txt"));
            text.add(this.container.usedSpace[0] + " / " + this.container.usedSpace[1]);
        } else if (this.isHovered(mouseX, mouseY, 41, 21, 8, 61)) {
            text.add(Localization.get((String)"gui.multistorage.junkbox.usedslots.txt"));
            text.add(this.container.usedSlots + " / " + this.chestTile.getChestSize());
        }
        if (!text.isEmpty()) {
            int winLeft = (this.field_146294_l - this.field_146999_f) / 2;
            int winTop = (this.field_146295_m - this.field_147000_g) / 2;
            GuiFunctions.drawHoveringText(text, (int)(mouseX - winLeft), (int)(mouseY - winTop), (FontRenderer)this.field_146289_q, (GuiScreen)this);
        }
    }

    private boolean isHovered(int mX, int mY, int wX, int wY, int width, int height) {
        int left = (this.field_146294_l - this.field_146999_f) / 2 + wX;
        int top = (this.field_146295_m - this.field_147000_g) / 2 + wY;
        return mX > left && mY > top && mX < left + width && mY < top + height;
    }

    @Override
    protected void func_146977_a(Slot slot) {
        if (slot.func_111238_b()) {
            super.func_146977_a(slot);
        }
    }

    @Override
    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return slot.func_111238_b() && super.func_146981_a(slot, mouseX, mouseY);
    }
}

