/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.multistorage.Recipes;
import shetiphian.multistorage.Registry;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.misc.ConfigHandler;
import shetiphian.multistorage.common.misc.ProxyCommon;
import shetiphian.multistorage.common.network.NetworkHandler;
import shetiphian.multistorage.modintegration.ModIntegration;

@Mod(modid="multistorage", name="Multi-Storage", version="1.2.18b", dependencies="required-after:shetiphiancore@[v3.3.9,);after:terraqueous", guiFactory="shetiphian.multistorage.client.misc.ConfigGUIHandler", updateJSON="https://gist.githubusercontent.com/ShetiPhian/8f54131fc6436c8c85a5/raw/MultiStorage", acceptedMinecraftVersions="[1.10.2]")
public class MultiStorage {
    @SidedProxy(clientSide="shetiphian.multistorage.client.misc.ProxyClient", serverSide="shetiphian.multistorage.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="multistorage")
    public static MultiStorage INSTANCE;
    public static final String MOD_ID = "multistorage";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logMultiStorage = event.getModLog();
        Values.tabMultiStorage = new MyCreativeTab("MultiStorage");
        Values.minecraftDir = event.getModConfigurationDirectory().getParentFile().getAbsolutePath();
        proxy.setupConfig(event.getSuggestedConfigurationFile());
        new Registry().doRegistration();
        new ModIntegration().preInit();
        proxy.renderingPreInt();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        ConfigHandler.INSTANCE.processLists();
        NetworkHandler.initialise();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        new Recipes().loadRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        new ModIntegration().load();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        ChestHelper.INSTANCE.loadChestData();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        ChestHelper.INSTANCE.unloadChestData();
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        Values.logMultiStorage.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static ItemStack getCustomItemStack(String name, int ... amount) {
        return Values.stacks.get(name, amount);
    }

    static {
        if (!FluidRegistry.isUniversalBucketEnabled()) {
            FluidRegistry.enableUniversalBucket();
        }
    }
}

