/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.world;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import teamroots.embers.util.NoiseGenUtil;

public class EmberWorldData
extends WorldSavedData {
    public Map<String, Double> emberData = new HashMap<String, Double>();
    public Map<String, Long> emberTimes = new HashMap<String, Long>();
    public long seed = 0L;
    public long ticks = 0L;

    public EmberWorldData(String name) {
        super(name);
    }

    public EmberWorldData() {
        super("embers:ember");
    }

    public static String getChunkString(int chunkX, int chunkY) {
        return "" + chunkX + "_" + chunkY;
    }

    public static double getEmberNoise(long seed, int x, int y) {
        return (Math.pow(NoiseGenUtil.getOctave(seed, x, y, 15), 5.0) * 256.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 12), 5.0) * 240.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 8), 5.0) * 128.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 7), 5.0) * 100.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 4), 5.0) * 40.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 3), 5.0) * 32.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 2), 5.0) * 16.0 + Math.pow(NoiseGenUtil.getOctave(seed, x, y, 1), 5.0) * 10.0) * 1000.0;
    }

    public double getEmberForChunk(int chunkX, int chunkY) {
        String chunkString = EmberWorldData.getChunkString(chunkX, chunkY);
        if (!this.emberData.containsKey(chunkString)) {
            this.emberData.put(chunkString, EmberWorldData.getEmberNoise(this.seed, chunkX, chunkY));
            this.emberTimes.put(chunkString, this.ticks);
            this.func_76185_a();
        } else if (!this.emberTimes.containsKey(chunkString)) {
            this.emberTimes.put(chunkString, this.ticks);
        } else {
            long dTime = this.ticks - this.emberTimes.get(chunkString);
            if (dTime < 0L) {
                dTime = Long.MAX_VALUE - this.emberTimes.get(chunkString) + this.ticks;
            }
            this.emberTimes.replace(chunkString, this.ticks);
            this.emberData.replace(chunkString, Math.min(EmberWorldData.getEmberNoise(this.seed, chunkX, chunkY), this.emberData.get(chunkString) + (double)dTime / 100.0));
            this.func_76185_a();
        }
        return this.emberData.get(chunkString);
    }

    public void setEmberForChunk(int chunkX, int chunkY, double value) {
        double previous;
        String chunkString = EmberWorldData.getChunkString(chunkX, chunkY);
        double d = previous = this.emberData.containsKey(chunkString) ? this.emberData.get(chunkString) : 0.0;
        if (!this.emberData.containsKey(chunkString)) {
            this.emberData.put(chunkString, value);
            this.emberTimes.put(chunkString, this.ticks);
            this.func_76185_a();
        } else {
            if (!this.emberTimes.containsKey(chunkString)) {
                this.emberTimes.put(chunkString, this.ticks);
            } else {
                this.emberTimes.replace(chunkString, this.ticks);
            }
            this.emberData.replace(chunkString, value);
            this.func_76185_a();
        }
        if (value != this.emberData.get(chunkString)) {
            System.out.println("Desired: " + value + ", Curr: " + this.emberData.get(chunkString));
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.seed = tag.func_74763_f("seed");
        this.ticks = tag.func_74763_f("ticks");
        if (tag.func_74764_b("embers:emberLocations")) {
            NBTTagList list = tag.func_150295_c("embers:emberLocations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound location = list.func_150305_b(i);
                this.emberData.put(location.func_74779_i("pos"), location.func_74769_h("value"));
                this.emberTimes.put(location.func_74779_i("pos"), location.func_74763_f("time"));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        tag.func_74772_a("seed", this.seed);
        tag.func_74772_a("ticks", this.ticks);
        String[] keys = this.emberData.keySet().toArray(new String[this.emberData.keySet().size()]);
        Double[] values = this.emberData.values().toArray(new Double[this.emberData.keySet().size()]);
        Long[] times = this.emberTimes.values().toArray(new Long[this.emberData.keySet().size()]);
        for (int i = 0; i < keys.length; ++i) {
            NBTTagCompound location = new NBTTagCompound();
            location.func_74778_a("pos", keys[i]);
            location.func_74780_a("value", values[i].doubleValue());
            location.func_74780_a("time", (double)times[i].longValue());
            list.func_74742_a((NBTBase)location);
        }
        tag.func_74782_a("embers:emberLocations", (NBTBase)list);
        return tag;
    }

    public static EmberWorldData get(World world) {
        EmberWorldData data = null;
        if (world != null && (EmberWorldData)world.func_72943_a(EmberWorldData.class, "embers:ember") != null) {
            data = (EmberWorldData)world.func_72943_a(EmberWorldData.class, "embers:ember");
        }
        if (data == null && world != null) {
            data = new EmberWorldData();
            data.seed = world.func_72905_C();
            world.func_72823_a("embers:ember", (WorldSavedData)data);
        }
        return data;
    }
}

