/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.util.Misc;
import teamroots.embers.util.StructUV;

public class RenderUtil {
    public static final float root2over2 = (float)Math.sqrt(2.0) / 2.0f;

    public static void renderBeam(VertexBuffer buf, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a, float radius, double angle) {
        int lightx = 0xF000F0;
        int lighty = 0xF000F0;
        double yaw = Misc.yawDegreesBetweenPoints(x1, y1, z1, x2, y2, z2);
        double pitch = Misc.pitchDegreesBetweenPoints(x1, y1, z1, x2, y2, z2);
        float yawCos = MathHelper.func_76134_b((float)((float)Math.toRadians(yaw)));
        float yawSin = MathHelper.func_76126_a((float)((float)Math.toRadians(yaw)));
        float pitchCos = MathHelper.func_76134_b((float)((float)Math.toRadians(pitch)));
        float pitchSin = MathHelper.func_76126_a((float)((float)Math.toRadians(pitch)));
        float angCos = MathHelper.func_76134_b((float)((float)Math.toRadians(angle)));
        float angSin = MathHelper.func_76126_a((float)((float)Math.toRadians(angle)));
        float dxh = radius * yawCos * pitchCos;
        float dyh = 0.0f;
        float dzh = radius * -yawSin * pitchCos;
        float dxv = radius * 0.5f * -yawSin * pitchSin;
        float dyv = radius * 0.5f * pitchCos;
        float dzv = radius * 0.5f * -yawCos * pitchSin;
        float dx = dxh * angCos + dxv * angSin;
        float dy = dyh * angCos + dyv * angSin;
        float dz = dzh * angCos + dzv * angSin;
        float dx2 = dxh * -angSin + dxv * angCos;
        float dy2 = dyh * -angSin + dyv * angCos;
        float dz2 = dzh * -angSin + dzv * angCos;
        double distX = x2 - x1;
        double distY = y2 - y1;
        double distZ = z2 - z1;
        buf.func_181662_b(x1 - (double)dx, y1 - (double)dy, z1 - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + (double)dx, y1 + (double)dy, z1 + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx, y1 + distY * (double)0.1f + (double)dy, z1 + distZ * (double)0.1f + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx, y1 + distY * (double)0.1f - (double)dy, z1 + distZ * (double)0.1f - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 - (double)dx2, y1 - (double)dy2, z1 - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + (double)dx2, y1 + (double)dy2, z1 + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx2, y1 + distY * (double)0.1f + (double)dy2, z1 + distZ * (double)0.1f + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx2, y1 + distY * (double)0.1f - (double)dy2, z1 + distZ * (double)0.1f - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx, y1 + distY * (double)0.1f - (double)dy, z1 + distZ * (double)0.1f - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx, y1 + distY * (double)0.1f + (double)dy, z1 + distZ * (double)0.1f + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx, y1 + distY * (double)0.9f + (double)dy, z1 + distZ * (double)0.9f + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx, y1 + distY * (double)0.9f - (double)dy, z1 + distZ * (double)0.9f - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f - (double)dx2, y1 + distY * (double)0.1f - (double)dy2, z1 + distZ * (double)0.1f - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.1f + (double)dx2, y1 + distY * (double)0.1f + (double)dy2, z1 + distZ * (double)0.1f + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx2, y1 + distY * (double)0.9f + (double)dy2, z1 + distZ * (double)0.9f + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx2, y1 + distY * (double)0.9f - (double)dy2, z1 + distZ * (double)0.9f - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx, y1 + distY * (double)0.9f - (double)dy, z1 + distZ * (double)0.9f - (double)dz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx, y1 + distY * (double)0.9f + (double)dy, z1 + distZ * (double)0.9f + (double)dz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX + (double)dx, y1 + distY + (double)dy, z1 + distZ + (double)dz).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX - (double)dx, y1 + distY - (double)dy, z1 + distZ - (double)dz).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f - (double)dx2, y1 + distY * (double)0.9f - (double)dy2, z1 + distZ * (double)0.9f - (double)dz2).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX * (double)0.9f + (double)dx2, y1 + distY * (double)0.9f + (double)dy2, z1 + distZ * (double)0.9f + (double)dz2).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x1 + distX + (double)dx2, y1 + distY + (double)dy2, z1 + distZ + (double)dz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
        buf.func_181662_b(x1 + distX - (double)dx2, y1 + distY - (double)dy2, z1 + distZ - (double)dz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, 0.0f).func_181675_d();
    }

    public static void renderAlchemyCircle(VertexBuffer buf, double x, double y, double z, float r, float g, float b, float a, double radius, double angle) {
        double sign = 1.0;
        if (Minecraft.func_71410_x().field_71439_g.field_70163_u + (double)Minecraft.func_71410_x().field_71439_g.func_70047_e() < y) {
            sign = -1.0;
        }
        int lightx = 0xF000F0;
        int lighty = 0xF000F0;
        for (double i = 0.0; i < 360.0; i += 10.0) {
            double tx = Math.sin(Math.toRadians(i + angle));
            double tz = Math.cos(Math.toRadians(i + angle));
            double tx2 = Math.sin(Math.toRadians(i + angle + 10.0));
            double tz2 = Math.cos(Math.toRadians(i + angle + 10.0));
            buf.func_181662_b(x + radius * tx, y, z + radius * tz).func_187315_a(0.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + (radius + 0.25) * tx, y, z + (radius + 0.25) * tz).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + (radius + 0.25) * tx2, y, z + (radius + 0.25) * tz2).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
            buf.func_181662_b(x + radius * tx2, y, z + radius * tz2).func_187315_a(1.0, 0.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        }
        double ax = (radius + 0.24) * Math.sin(Math.toRadians(0.0 + angle));
        double az = (radius + 0.24) * Math.cos(Math.toRadians(0.0 + angle));
        double adx = 0.1875 * Math.cos(Math.toRadians(0.0 + angle));
        double adz = 0.1875 * -Math.sin(Math.toRadians(0.0 + angle));
        double bx = (radius + 0.24) * Math.sin(Math.toRadians(120.0 + angle));
        double bz = (radius + 0.24) * Math.cos(Math.toRadians(120.0 + angle));
        double bdx = 0.1875 * Math.cos(Math.toRadians(120.0 + angle));
        double bdz = 0.1875 * -Math.sin(Math.toRadians(120.0 + angle));
        double cx = (radius + 0.24) * Math.sin(Math.toRadians(240.0 + angle));
        double cz = (radius + 0.24) * Math.cos(Math.toRadians(240.0 + angle));
        double cdx = 0.1875 * Math.cos(Math.toRadians(240.0 + angle));
        double cdz = 0.1875 * -Math.sin(Math.toRadians(240.0 + angle));
        buf.func_181662_b(x + (ax - adx), y + 5.0E-5 * sign, z + (az - adz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax + adx), y + 5.0E-5 * sign, z + (az + adz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx - bdx), y + 5.0E-5 * sign, z + (bz - bdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx + bdx), y + 5.0E-5 * sign, z + (bz + bdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx - bdx), y + 1.0E-4 * sign, z + (bz - bdz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (bx + bdx), y + 1.0E-4 * sign, z + (bz + bdz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx - cdx), y + 1.0E-4 * sign, z + (cz - cdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx + cdx), y + 1.0E-4 * sign, z + (cz + cdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax - adx), y + 1.5E-4 * sign, z + (az - adz)).func_187315_a(0.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (ax + adx), y + 1.5E-4 * sign, z + (az + adz)).func_187315_a(0.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx - cdx), y + 1.5E-4 * sign, z + (cz - cdz)).func_187315_a(1.0, 1.0).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
        buf.func_181662_b(x + (cx + cdx), y + 1.5E-4 * sign, z + (cz + cdz)).func_187315_a(1.0, 0.5).func_187314_a(lightx, lighty).func_181666_a(r, g, b, a).func_181675_d();
    }

    public static void addBox(VertexBuffer b, double x1, double y1, double z1, double x2, double y2, double z2, StructUV[] textures, int[] inversions) {
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[0].minU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[0].maxU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[0].maxU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[0].minU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[1].minU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[1].maxU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[1].maxU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[1].minU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[2].minU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[2].maxU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[2].maxU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[2].minU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[3].minU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[3].maxU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[3].maxU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[3].minU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a(textures[4].minU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a(textures[4].maxU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a(textures[4].maxU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a(textures[4].minU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a(textures[5].minU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a(textures[5].maxU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a(textures[5].maxU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a(textures[5].minU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
    }

    public static void addBoxWithSprite(VertexBuffer b, double x1, double y1, double z1, double x2, double y2, double z2, TextureAtlasSprite sprite, StructUV[] textures, int[] inversions) {
        float spriteW = sprite.func_94212_f() - sprite.func_94209_e();
        float spriteH = sprite.func_94210_h() - sprite.func_94206_g();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[0].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[0].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[0].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[0].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[0].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[1].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[1].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[1].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[1].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[1].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[2].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[2].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[3].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[3].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        b.func_181662_b(x1, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[4].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[4].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[4].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x1, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[4].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[4].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z1).func_187315_a((double)sprite.func_94209_e() + textures[5].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y1, z2).func_187315_a((double)sprite.func_94209_e() + textures[5].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].minV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z2).func_187315_a((double)sprite.func_94209_e() + textures[5].maxU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        b.func_181662_b(x2, y2, z1).func_187315_a((double)sprite.func_94209_e() + textures[5].minU * (double)spriteW, (double)sprite.func_94206_g() + textures[5].maxV * (double)spriteH).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
    }

    public static void addBoxExt(VertexBuffer b, double x1, double y1, double z1, double x2, double y2, double z2, StructUV[] textures, int[] inversions, boolean[] faceToggles) {
        if (faceToggles[0]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[0].minU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[0].maxU, textures[0].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[0].maxU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[0].minU, textures[0].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(-1 * inversions[0]), 0.0f).func_181675_d();
        }
        if (faceToggles[1]) {
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[1].minU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[1].maxU, textures[1].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[1].maxU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[1].minU, textures[1].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, (float)(1 * inversions[1]), 0.0f).func_181675_d();
        }
        if (faceToggles[2]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[2].minU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[2].maxU, textures[2].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[2].maxU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[2].minU, textures[2].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(-1 * inversions[2])).func_181675_d();
        }
        if (faceToggles[3]) {
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[3].minU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[3].maxU, textures[3].minV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[3].maxU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[3].minU, textures[3].maxV).func_181669_b(255, 255, 255, 255).func_181663_c(0.0f, 0.0f, (float)(1 * inversions[3])).func_181675_d();
        }
        if (faceToggles[4]) {
            b.func_181662_b(x1, y1, z1).func_187315_a(textures[4].minU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y1, z2).func_187315_a(textures[4].maxU, textures[4].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z2).func_187315_a(textures[4].maxU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x1, y2, z1).func_187315_a(textures[4].minU, textures[4].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(-1 * inversions[4]), 0.0f, 0.0f).func_181675_d();
        }
        if (faceToggles[5]) {
            b.func_181662_b(x2, y1, z1).func_187315_a(textures[5].minU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y1, z2).func_187315_a(textures[5].maxU, textures[5].minV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z2).func_187315_a(textures[5].maxU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
            b.func_181662_b(x2, y2, z1).func_187315_a(textures[5].minU, textures[5].maxV).func_181669_b(255, 255, 255, 255).func_181663_c((float)(1 * inversions[5]), 0.0f, 0.0f).func_181675_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuadGui(VertexBuffer vertexbuffer, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int minU, int minV, int maxU, int maxV) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        vertexbuffer.func_181662_b((double)(x1 + 0.0f), (double)(y1 + 0.0f), 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x2 + 0.0f), (double)(y2 + 0.0f), 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x3 + 0.0f), (double)(y3 + 0.0f), 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x4 + 0.0f), (double)(y4 + 0.0f), 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawQuadGuiExt(VertexBuffer vertexbuffer, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, int minU, int minV, int maxU, int maxV, int texW, int texH) {
        float mU = (float)minU / (float)texW;
        float mV = (float)minV / (float)texH;
        float xU = (float)maxU / (float)texW;
        float xV = (float)maxV / (float)texH;
        vertexbuffer.func_181662_b((double)(x1 + 0.0f), (double)(y1 + 0.0f), 0.0).func_187315_a((double)mU, (double)xV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x2 + 0.0f), (double)(y2 + 0.0f), 0.0).func_187315_a((double)xU, (double)xV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x3 + 0.0f), (double)(y3 + 0.0f), 0.0).func_187315_a((double)xU, (double)mV).func_181675_d();
        vertexbuffer.func_181662_b((double)(x4 + 0.0f), (double)(y4 + 0.0f), 0.0).func_187315_a((double)mU, (double)mV).func_181675_d();
    }
}

