/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class Misc {
    public static Random random = new Random();

    public static boolean isExtremeHills(Biome biome) {
        return biome.func_185359_l().compareTo(Biomes.field_76770_e.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76783_v.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150580_W.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185443_S.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185434_af.func_185359_l()) == 0;
    }

    public static EnumFacing getOppositeHorizontalFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.DOWN;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.UP;
        }
        return face.func_176734_d();
    }

    public static EntityItem rayTraceItem(World world, double posX, double posY, double posZ, double dirX, double dirY, double dirZ) {
        double x = posX;
        double y = posY;
        double z = posZ;
        for (int i = 0; i < 120; ++i) {
            List items;
            if ((items = world.func_72872_a(EntityItem.class, new AxisAlignedBB((x += dirX / 20.0) - 0.2, (y += dirY / 20.0) - 0.2, (z += dirZ / 20.0) - 0.2, x + 0.2, y + 0.2, z + 0.2))).size() <= 0) continue;
            return (EntityItem)items.get(0);
        }
        return null;
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static boolean matchOreDict(ItemStack stack1, ItemStack stack2) {
        int[] keys1 = OreDictionary.getOreIDs((ItemStack)stack1);
        int[] keys2 = OreDictionary.getOreIDs((ItemStack)stack2);
        for (int i = 0; i < keys1.length; ++i) {
            for (int j = 0; j < keys2.length; ++j) {
                if (keys1[i] != keys2[j]) continue;
                return true;
            }
        }
        return false;
    }

    public static float yawDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        float f = (float)(180.0 * Math.atan2(posX2 - posX, posZ2 - posZ) / 3.1415927410125732);
        return f;
    }

    public static float pitchDegreesBetweenPoints(double posX, double posY, double posZ, double posX2, double posY2, double posZ2) {
        return (float)Math.toDegrees(Math.atan2(posY2 - posY, Math.sqrt((posX2 - posX) * (posX2 - posX) + (posZ2 - posZ) * (posZ2 - posZ))));
    }

    public static EnumFacing getOppositeFace(EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return EnumFacing.UP;
        }
        if (face == EnumFacing.UP) {
            return EnumFacing.DOWN;
        }
        return face.func_176734_d();
    }

    public static boolean isHills(Biome biome) {
        return biome.func_185359_l().compareTo(Biomes.field_150582_Q.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150579_T.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76786_s.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76785_t.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76792_x.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185429_aa.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_185433_ae.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_150581_V.func_185359_l()) == 0 || biome.func_185359_l().compareTo(Biomes.field_76784_u.func_185359_l()) == 0;
    }

    public static void spawnInventoryInWorld(World world, double x, double y, double z, IItemHandler inventory) {
        if (inventory != null && !world.field_72995_K) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (inventory.getStackInSlot(i) == null) continue;
                world.func_72838_d((Entity)new EntityItem(world, x, y, z, inventory.getStackInSlot(i)));
            }
        }
    }
}

