/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPipe;
import teamroots.embers.util.Misc;

public class TileEntityPump
extends TileEntityPipe
implements ITileEntityBase,
ITickable {
    Random random = new Random();

    public static TileEntityPipe.EnumPipeConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return TileEntityPipe.EnumPipeConnection.NONE;
            }
            case 1: {
                return TileEntityPipe.EnumPipeConnection.PIPE;
            }
            case 2: {
                return TileEntityPipe.EnumPipeConnection.BLOCK;
            }
            case 3: {
                return TileEntityPipe.EnumPipeConnection.LEVER;
            }
            case 4: {
                return TileEntityPipe.EnumPipeConnection.FORCENONE;
            }
        }
        return TileEntityPipe.EnumPipeConnection.NONE;
    }

    public TileEntityPump() {
        this.tank.setCapacity(1000);
    }

    @Override
    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityPump.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityPump.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityPump.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityPump.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityPump.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityPump.connectionFromInt(tag.func_74762_e("east"));
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public TileEntityPipe.EnumPipeConnection getConnection(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return this.up;
        }
        if (side == EnumFacing.DOWN) {
            return this.down;
        }
        if (side == EnumFacing.EAST) {
            return this.east;
        }
        if (side == EnumFacing.WEST) {
            return this.west;
        }
        if (side == EnumFacing.NORTH) {
            return this.north;
        }
        if (side == EnumFacing.SOUTH) {
            return this.south;
        }
        return TileEntityPipe.EnumPipeConnection.NONE;
    }

    @Override
    public void setConnection(EnumFacing side, TileEntityPipe.EnumPipeConnection connect) {
        if (side == EnumFacing.UP) {
            this.up = connect;
        } else if (side == EnumFacing.DOWN) {
            this.down = connect;
        } else if (side == EnumFacing.EAST) {
            this.east = connect;
        } else if (side == EnumFacing.WEST) {
            this.west = connect;
        } else if (side == EnumFacing.NORTH) {
            this.north = connect;
        } else if (side == EnumFacing.SOUTH) {
            this.south = connect;
        }
    }

    @Override
    public void reverseConnection(EnumFacing face) {
    }

    public static TileEntityPipe.EnumPipeConnection reverseForce(TileEntityPipe.EnumPipeConnection connect) {
        if (connect == TileEntityPipe.EnumPipeConnection.FORCENONE) {
            return TileEntityPipe.EnumPipeConnection.NONE;
        }
        if (connect != TileEntityPipe.EnumPipeConnection.NONE && connect != TileEntityPipe.EnumPipeConnection.LEVER) {
            return TileEntityPipe.EnumPipeConnection.FORCENONE;
        }
        return TileEntityPipe.EnumPipeConnection.NONE;
    }

    @Override
    public TileEntityPipe.EnumPipeConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing face;
        if (this.getConnection(side) == TileEntityPipe.EnumPipeConnection.FORCENONE) {
            return TileEntityPipe.EnumPipeConnection.FORCENONE;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) && !(world.func_175625_s(pos) instanceof TileEntityPump)) {
            return TileEntityPipe.EnumPipeConnection.BLOCK;
        }
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at && ((face = ((BlockLever.EnumOrientation)world.func_180495_p(pos).func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c()) == side || face == EnumFacing.DOWN && side == EnumFacing.UP || face == EnumFacing.UP && side == EnumFacing.DOWN)) {
            return TileEntityPipe.EnumPipeConnection.LEVER;
        }
        return TileEntityPipe.EnumPipeConnection.NONE;
    }

    @Override
    public boolean isConnected(EnumFacing face) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(face));
        if (tile instanceof TileEntityPipe && ((TileEntityPipe)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityPipe.EnumPipeConnection.FORCENONE && ((TileEntityPipe)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityPipe.EnumPipeConnection.NONE) {
            return true;
        }
        if (tile instanceof TileEntityPump && ((TileEntityPump)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityPipe.EnumPipeConnection.FORCENONE && ((TileEntityPump)tile).getConnection(Misc.getOppositeFace(face)) != TileEntityPipe.EnumPipeConnection.NONE) {
            return true;
        }
        return this.getConnection(face) == TileEntityPipe.EnumPipeConnection.BLOCK;
    }

    @Override
    public void func_73660_a() {
        ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && this.func_145831_w().func_175687_A(this.func_174877_v()) != 0) {
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if (this.up == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.UP)) {
                connectedFaces.add(EnumFacing.UP);
            }
            if (this.down == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.DOWN)) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if (this.north == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.NORTH)) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if (this.south == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.SOUTH)) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if (this.west == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.WEST)) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if (this.east == TileEntityPipe.EnumPipeConnection.BLOCK && this.isConnected(EnumFacing.EAST)) {
                connectedFaces.add(EnumFacing.EAST);
            }
            for (int i = 0; i < connectedFaces.size(); ++i) {
                IFluidHandler handler;
                if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))) == null || (handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                IFluidTankProperties[] properties = handler.getTankProperties();
                for (int j = 0; j < properties.length && this.tank.getFluidAmount() < this.tank.getCapacity(); ++j) {
                    FluidStack stack = properties[j].getContents();
                    if (stack == null) continue;
                    int taken = this.tank.fill(stack, true);
                    handler.drain(new FluidStack(stack.getFluid(), taken), true);
                    IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
        }
        if (this.tank.getFluid() != null) {
            int distAmount = this.tank.getFluidAmount();
            ArrayList<EnumFacing> connectedFaces = new ArrayList<EnumFacing>();
            if (this.up == TileEntityPipe.EnumPipeConnection.PIPE || this.up == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.UP);
            }
            if (this.down == TileEntityPipe.EnumPipeConnection.PIPE || this.down == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.DOWN);
            }
            if (this.north == TileEntityPipe.EnumPipeConnection.PIPE || this.north == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.NORTH);
            }
            if (this.south == TileEntityPipe.EnumPipeConnection.PIPE || this.south == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.SOUTH);
            }
            if (this.west == TileEntityPipe.EnumPipeConnection.PIPE || this.west == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.WEST);
            }
            if (this.east == TileEntityPipe.EnumPipeConnection.PIPE || this.east == TileEntityPipe.EnumPipeConnection.BLOCK) {
                connectedFaces.add(EnumFacing.EAST);
            }
            if (connectedFaces.size() > 0) {
                int toEach = distAmount / connectedFaces.size();
                for (int i = 0; i < connectedFaces.size(); ++i) {
                    IFluidHandler handler;
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))) == null || (handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null || this.tank.getFluid() == null) continue;
                    FluidStack toAdd = new FluidStack(this.tank.getFluid().getFluid(), toEach);
                    int filled = handler.fill(toAdd, true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), filled), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
            if (this.tank.getFluidAmount() <= connectedFaces.size()) {
                while (this.tank.getFluidAmount() > 0) {
                    IFluidHandler handler;
                    int i = this.random.nextInt(connectedFaces.size());
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))) == null || (handler = (IFluidHandler)this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i))).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, ((EnumFacing)connectedFaces.get(i)).func_176734_d())) == null) continue;
                    int filled = handler.fill(new FluidStack(this.tank.getFluid().getFluid(), 1), true);
                    this.tank.drainInternal(new FluidStack(this.tank.getFluid().getFluid(), 1), true);
                    if (!toUpdate.contains(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)))) {
                        toUpdate.add(this.func_174877_v().func_177972_a((EnumFacing)connectedFaces.get(i)));
                    }
                    if (toUpdate.contains(this.func_174877_v())) continue;
                    toUpdate.add(this.func_174877_v());
                }
            }
        }
        for (int i = 0; i < toUpdate.size(); ++i) {
            this.func_145831_w().func_175625_s((BlockPos)toUpdate.get(i)).func_70296_d();
            if (this.func_145831_w().field_72995_K) continue;
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate((TileEntity)this));
        }
    }
}

