/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import teamroots.embers.tileentity.TileEntityFurnaceTop;
import teamroots.embers.util.FluidTextureUtil;

public class TileEntityFurnaceTopRenderer
extends TileEntitySpecialRenderer {
    RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
    int blue;
    int green;
    int red;
    int alpha;
    int lightx;
    int lighty;
    double minU;
    double minV;
    double maxU;
    double maxV;
    double diffU;
    double diffV;

    public void func_180535_a(TileEntity tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tile instanceof TileEntityFurnaceTop) {
            TileEntityFurnaceTop furnace = (TileEntityFurnaceTop)tile;
            int amount = furnace.getAmount();
            int capacity = furnace.getCapacity();
            Fluid fluid = furnace.getFluid();
            for (int i = 0; i < furnace.inventory.getSlots(); ++i) {
                ItemStack stack = furnace.inventory.getStackInSlot(i);
                if (stack == null) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)y, (double)(z + 0.5));
                GlStateManager.func_179114_b((float)(1.0f * ((float)furnace.angle + partialTicks)), (float)0.0f, (float)1.0f, (float)0.0f);
                EntityItem item = new EntityItem(tile.func_145831_w(), 0.0, 0.0, 0.0, stack);
                item.field_70290_d = 0.0f;
                Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)item, 0.0, 0.0, 0.0, 0.0f, 0.0f, true);
                GlStateManager.func_179121_F();
            }
            if (fluid != null) {
                int c = fluid.getColor();
                this.blue = c & 0xFF;
                this.green = c >> 8 & 0xFF;
                this.red = c >> 16 & 0xFF;
                this.alpha = c >> 24 & 0xFF;
                TextureAtlasSprite sprite = FluidTextureUtil.stillTextures.get(fluid);
                this.diffU = this.maxU - this.minU;
                this.diffV = this.maxV - this.minV;
                this.minU = (double)sprite.func_94209_e() + this.diffU * 0.25;
                this.maxU = (double)sprite.func_94212_f() - this.diffU * 0.25;
                this.minV = (double)sprite.func_94206_g() + this.diffV * 0.25;
                this.maxV = (double)sprite.func_94210_h() - this.diffV * 0.25;
                int i = this.func_178459_a().func_175626_b(tile.func_174877_v(), fluid.getLuminosity());
                this.lightx = i >> 16 & 0xFFFF;
                this.lighty = i & 0xFFFF;
                GlStateManager.func_179129_p();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator tess = Tessellator.func_178181_a();
                VertexBuffer buffer = tess.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                buffer.func_181662_b(x + 0.25, y + 0.0625 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).func_187315_a(this.minU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.0625 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.25).func_187315_a(this.maxU, this.minV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.75, y + 0.0625 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).func_187315_a(this.maxU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                buffer.func_181662_b(x + 0.25, y + 0.0625 + 0.8125 * (double)((float)amount / (float)capacity), z + 0.75).func_187315_a(this.minU, this.maxV).func_187314_a(this.lightx, this.lighty).func_181669_b(this.red, this.green, this.blue, this.alpha).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179089_o();
            }
        }
    }
}

