/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.RegistryManager;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberData;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;
import teamroots.embers.world.EmberWorldData;

public class TileEntityEmberBore
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    Random random = new Random();
    public long ticksExisted = 0L;
    public float angle = 0.0f;
    public int ticksFueled = 0;
    int stackShards = 0;
    int stackCrystals = 1;
    int stackFuel = 2;
    public ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TileEntityEmberBore.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityEmberBore.this));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == TileEntityEmberBore.this.stackCrystals || slot == TileEntityEmberBore.this.stackShards) {
                return this.insertItem(slot + 1, stack, simulate);
            }
            if (slot == TileEntityEmberBore.this.stackFuel && TileEntityFurnace.func_145952_a((ItemStack)stack) == 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == TileEntityEmberBore.this.stackFuel) {
                return null;
            }
            return super.extractItem(slot, amount, simulate);
        }
    };

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("fueled", this.ticksFueled);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.ticksFueled = tag.func_74762_e("fueled");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        if (this.func_174877_v().func_177956_o() <= 7 && !this.func_145831_w().field_72995_K) {
            if (this.ticksFueled > 0) {
                this.angle += 12.0f;
            }
            ++this.ticksExisted;
            if (this.ticksFueled > 0) {
                --this.ticksFueled;
            }
            if (this.ticksFueled == 0) {
                EmberWorldData data = EmberWorldData.get(this.func_145831_w());
                double ember = data.getEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f));
                if (ember > 750.0 && this.inventory.getStackInSlot(this.stackFuel) != null) {
                    this.ticksFueled = TileEntityFurnace.func_145952_a((ItemStack)this.inventory.getStackInSlot(this.stackFuel).func_77946_l());
                    --this.inventory.getStackInSlot((int)this.stackFuel).field_77994_a;
                    if (this.inventory.getStackInSlot((int)this.stackFuel).field_77994_a <= 0) {
                        this.inventory.setStackInSlot(this.stackFuel, null);
                    }
                    this.func_70296_d();
                    if (!this.func_145831_w().field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    }
                }
            } else if (this.ticksExisted % 800L == 0L) {
                EmberWorldData data = EmberWorldData.get(this.func_145831_w());
                double ember = data.getEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f));
                int chance = this.random.nextInt(4);
                if (chance == 0) {
                    if (ember > 4500.0) {
                        if (this.inventory.getStackInSlot(this.stackCrystals) != null) {
                            if (this.inventory.getStackInSlot((int)this.stackCrystals).field_77994_a < this.inventory.getStackInSlot(this.stackCrystals).func_77976_d()) {
                                this.inventory.getStackInSlot((int)this.stackCrystals).field_77994_a = Math.min(64, this.inventory.getStackInSlot((int)this.stackCrystals).field_77994_a);
                                data.setEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 4500.0);
                                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberData((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 4500.0));
                                data.func_76185_a();
                            }
                        } else {
                            this.inventory.setStackInSlot(this.stackCrystals, new ItemStack(RegistryManager.crystalEmber, 1));
                            data.setEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 4500.0);
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberData((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 4500.0));
                            data.func_76185_a();
                        }
                        this.func_70296_d();
                        if (!this.func_145831_w().field_72995_K) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                        }
                    }
                } else if (ember > 750.0) {
                    if (this.inventory.getStackInSlot(this.stackShards) != null) {
                        if (this.inventory.getStackInSlot((int)this.stackShards).field_77994_a < this.inventory.getStackInSlot(this.stackShards).func_77976_d()) {
                            this.inventory.getStackInSlot((int)this.stackShards).field_77994_a = Math.min(this.inventory.getStackInSlot(this.stackShards).func_77976_d(), this.inventory.getStackInSlot((int)this.stackShards).field_77994_a);
                            data.setEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 750.0);
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberData((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 750.0));
                            data.func_76185_a();
                        }
                    } else {
                        this.inventory.setStackInSlot(this.stackShards, new ItemStack(RegistryManager.shardEmber, 1));
                        data.setEmberForChunk((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 750.0);
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberData((int)Math.floor((float)this.func_174877_v().func_177958_n() / 16.0f), (int)Math.floor((float)this.func_174877_v().func_177952_p() / 16.0f), ember - 750.0));
                        data.func_76185_a();
                    }
                    this.func_70296_d();
                    if (!this.func_145831_w().field_72995_K) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    }
                }
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }
}

