/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.item.IEmberItem;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityCharger
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityCharger.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityCharger.this));
        }
    };
    Random random = new Random();

    public TileEntityCharger() {
        this.capability.setEmberCapacity(24000.0);
        this.capability.setEmber(0.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null) {
            if (heldItem.func_77973_b() instanceof IEmberItem) {
                player.func_184611_a(hand, this.inventory.insertItem(0, heldItem, false));
                this.func_70296_d();
                if (!this.func_145831_w().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                }
                return true;
            }
        } else if (this.inventory.getStackInSlot(0) != null) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_184611_a(hand, this.inventory.extractItem(0, this.inventory.getStackInSlot((int)0).field_77994_a, false));
                this.func_70296_d();
                if (!this.func_145831_w().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        this.turnRate = 1;
        if (this.inventory.getStackInSlot(0) != null && this.capability.getEmber() > 0.0 && this.inventory.getStackInSlot(0).func_77973_b() instanceof IEmberItem) {
            double emberAdded = ((IEmberItem)this.inventory.getStackInSlot(0).func_77973_b()).addAmount(this.inventory.getStackInSlot(0), Math.min(10.0, this.capability.getEmber()), true);
            this.capability.removeAmount(emberAdded, true);
            this.func_70296_d();
            if (!this.func_145831_w().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
            } else if (this.capability.getEmber() > 0.0 && this.func_145831_w().field_72995_K) {
                int i = 0;
                while ((double)i < Math.ceil(this.capability.getEmber() / 500.0)) {
                    ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177956_o() + 0.25f + this.random.nextFloat() * 0.5f, (float)this.func_174877_v().func_177952_p() + 0.25f + this.random.nextFloat() * 0.5f, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                    ++i;
                }
            }
        }
        this.angle += this.turnRate;
    }
}

