/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.block.BlockBeamSplitter;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.power.IEmberPacketProducer;
import teamroots.embers.power.IEmberPacketReceiver;
import teamroots.embers.tileentity.ITileEntityBase;

public class TileEntityBeamSplitter
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    public BlockPos targetLeft = null;
    public BlockPos targetRight = null;
    long ticksExisted = 0L;

    public TileEntityBeamSplitter() {
        this.capability.setEmberCapacity(400.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        if (this.targetLeft != null) {
            tag.func_74768_a("targetLeftX", this.targetLeft.func_177958_n());
            tag.func_74768_a("targetLeftY", this.targetLeft.func_177956_o());
            tag.func_74768_a("targetLeftZ", this.targetLeft.func_177952_p());
        }
        if (this.targetRight != null) {
            tag.func_74768_a("targetRightX", this.targetRight.func_177958_n());
            tag.func_74768_a("targetRightY", this.targetRight.func_177956_o());
            tag.func_74768_a("targetRightZ", this.targetRight.func_177952_p());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("targetLeftX")) {
            this.targetLeft = new BlockPos(tag.func_74762_e("targetLeftX"), tag.func_74762_e("targetLeftY"), tag.func_74762_e("targetLeftZ"));
        }
        if (tag.func_74764_b("targetRightX")) {
            this.targetRight = new BlockPos(tag.func_74762_e("targetRightX"), tag.func_74762_e("targetRightY"), tag.func_74762_e("targetRightZ"));
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        if (this.ticksExisted % 20L == 0L && !this.func_145831_w().field_72995_K && this.capability.getEmber() > 0.0) {
            if (this.targetLeft != null && this.targetRight != null) {
                double amount = this.capability.getEmber() / 2.0;
                this.capability.setEmber(0.0);
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
                if (((Boolean)state.func_177229_b((IProperty)BlockBeamSplitter.isXAligned)).booleanValue()) {
                    if (this.func_145831_w().func_175625_s(this.targetLeft) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetLeft)).isFull()) {
                        EntityEmberPacket packetLeft = new EntityEmberPacket(this.func_145831_w());
                        packetLeft.initCustom(this.func_174877_v(), this.targetLeft, 0.0, -0.01, -0.5, amount);
                        this.func_145831_w().func_72838_d((Entity)packetLeft);
                    }
                    if (this.func_145831_w().func_175625_s(this.targetRight) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetRight)).isFull()) {
                        EntityEmberPacket packetRight = new EntityEmberPacket(this.func_145831_w());
                        packetRight.initCustom(this.func_174877_v(), this.targetRight, 0.0, -0.01, 0.5, amount);
                        this.func_145831_w().func_72838_d((Entity)packetRight);
                    }
                } else {
                    if (this.func_145831_w().func_175625_s(this.targetLeft) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetLeft)).isFull()) {
                        EntityEmberPacket packetLeft = new EntityEmberPacket(this.func_145831_w());
                        packetLeft.initCustom(this.func_174877_v(), this.targetLeft, -0.5, -0.01, 0.0, amount);
                        this.func_145831_w().func_72838_d((Entity)packetLeft);
                    }
                    if (this.func_145831_w().func_175625_s(this.targetRight) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetRight)).isFull()) {
                        EntityEmberPacket packetRight = new EntityEmberPacket(this.func_145831_w());
                        packetRight.initCustom(this.func_174877_v(), this.targetRight, 0.5, -0.01, 0.0, amount);
                        this.func_145831_w().func_72838_d((Entity)packetRight);
                    }
                }
            } else if (this.targetLeft != null) {
                double amount = this.capability.getEmber();
                this.capability.setEmber(0.0);
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
                if (((Boolean)state.func_177229_b((IProperty)BlockBeamSplitter.isXAligned)).booleanValue()) {
                    if (this.func_145831_w().func_175625_s(this.targetLeft) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetLeft)).isFull()) {
                        EntityEmberPacket packetLeft = new EntityEmberPacket(this.func_145831_w());
                        packetLeft.initCustom(this.func_174877_v(), this.targetLeft, 0.0, -0.01, -0.5, amount);
                        this.func_145831_w().func_72838_d((Entity)packetLeft);
                    }
                } else if (this.func_145831_w().func_175625_s(this.targetLeft) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetLeft)).isFull()) {
                    EntityEmberPacket packetLeft = new EntityEmberPacket(this.func_145831_w());
                    packetLeft.initCustom(this.func_174877_v(), this.targetLeft, -0.5, -0.01, 0.0, amount);
                    this.func_145831_w().func_72838_d((Entity)packetLeft);
                }
            } else if (this.targetRight != null) {
                double amount = this.capability.getEmber();
                this.capability.setEmber(0.0);
                this.func_70296_d();
                IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
                if (((Boolean)state.func_177229_b((IProperty)BlockBeamSplitter.isXAligned)).booleanValue()) {
                    if (this.func_145831_w().func_175625_s(this.targetRight) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetRight)).isFull()) {
                        EntityEmberPacket packetRight = new EntityEmberPacket(this.func_145831_w());
                        packetRight.initCustom(this.func_174877_v(), this.targetRight, 0.0, -0.01, 0.5, amount);
                        this.func_145831_w().func_72838_d((Entity)packetRight);
                    }
                } else if (this.func_145831_w().func_175625_s(this.targetRight) != null && !((IEmberPacketReceiver)this.func_145831_w().func_175625_s(this.targetRight)).isFull()) {
                    EntityEmberPacket packetRight = new EntityEmberPacket(this.func_145831_w());
                    packetRight.initCustom(this.func_174877_v(), this.targetRight, 0.5, -0.01, 0.0, amount);
                    this.func_145831_w().func_72838_d((Entity)packetRight);
                }
            }
        }
    }

    @Override
    public void setTargetPosition(BlockPos pos, EnumFacing side) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        if (((Boolean)state.func_177229_b((IProperty)BlockBeamSplitter.isXAligned)).booleanValue()) {
            if (side == EnumFacing.NORTH) {
                this.targetLeft = pos;
                this.func_70296_d();
            }
            if (side == EnumFacing.SOUTH) {
                this.targetRight = pos;
                this.func_70296_d();
            }
        } else {
            if (side == EnumFacing.WEST) {
                this.targetLeft = pos;
                this.func_70296_d();
            }
            if (side == EnumFacing.EAST) {
                this.targetRight = pos;
                this.func_70296_d();
            }
        }
    }
}

