/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.RegistryManager;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberSphereFX;
import teamroots.embers.network.message.MessageTEUpdate;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.RecipeRegistry;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityAlchemyPedestal;
import teamroots.embers.util.Misc;

public class TileEntityAlchemyTablet
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    int angle = 0;
    int turnRate = 0;
    public int progress = 0;
    int ash = 0;
    public int process = 0;
    int copper = 0;
    int iron = 0;
    int dawnstone = 0;
    int silver = 0;
    int lead = 0;
    public ItemStackHandler north = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityAlchemyTablet.this));
        }
    };
    public ItemStackHandler south = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityAlchemyTablet.this));
        }
    };
    public ItemStackHandler east = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityAlchemyTablet.this));
        }
    };
    public ItemStackHandler west = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityAlchemyTablet.this));
        }
    };
    public ItemStackHandler center = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityAlchemyTablet.this.func_70296_d();
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(TileEntityAlchemyTablet.this));
        }
    };
    Random random = new Random();

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("iron", this.iron);
        tag.func_74768_a("dawnstone", this.dawnstone);
        tag.func_74768_a("copper", this.copper);
        tag.func_74768_a("silver", this.silver);
        tag.func_74768_a("lead", this.lead);
        tag.func_74782_a("north", (NBTBase)this.north.serializeNBT());
        tag.func_74782_a("south", (NBTBase)this.south.serializeNBT());
        tag.func_74782_a("east", (NBTBase)this.east.serializeNBT());
        tag.func_74782_a("west", (NBTBase)this.west.serializeNBT());
        tag.func_74782_a("center", (NBTBase)this.center.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("progress");
        this.iron = tag.func_74762_e("iron");
        this.dawnstone = tag.func_74762_e("dawnstone");
        this.copper = tag.func_74762_e("copper");
        this.silver = tag.func_74762_e("silver");
        this.lead = tag.func_74762_e("lead");
        this.north.deserializeNBT(tag.func_74775_l("north"));
        this.south.deserializeNBT(tag.func_74775_l("south"));
        this.east.deserializeNBT(tag.func_74775_l("east"));
        this.west.deserializeNBT(tag.func_74775_l("west"));
        this.center.deserializeNBT(tag.func_74775_l("center"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != EnumFacing.UP) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.center;
            }
            if (facing == EnumFacing.NORTH) {
                return (T)this.north;
            }
            if (facing == EnumFacing.SOUTH) {
                return (T)this.south;
            }
            if (facing == EnumFacing.EAST) {
                return (T)this.east;
            }
            if (facing == EnumFacing.WEST) {
                return (T)this.west;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getSlotForPos(float hitX, float hitZ) {
        return (int)((double)hitX / 0.3333) * 3 + (int)((double)hitZ / 0.3333);
    }

    public ItemStackHandler getInventoryForFace(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return this.center;
        }
        if (facing == EnumFacing.NORTH) {
            return this.north;
        }
        if (facing == EnumFacing.SOUTH) {
            return this.south;
        }
        if (facing == EnumFacing.EAST) {
            return this.east;
        }
        if (facing == EnumFacing.WEST) {
            return this.west;
        }
        return this.center;
    }

    public void sparkProgress() {
        AlchemyRecipe recipe = RecipeRegistry.getAlchemyRecipe(this.center.getStackInSlot(0), this.east.getStackInSlot(0), this.west.getStackInSlot(0), this.north.getStackInSlot(0), this.south.getStackInSlot(0));
        if (recipe != null && this.getNearbyAsh(this.getNearbyPedestals()) >= recipe.dawnstoneAspectMin + recipe.copperAspectMin + recipe.ironAspectMin + recipe.silverAspectMin + recipe.leadAspectMin) {
            System.out.println(recipe.getIron(this.func_145831_w()) + " " + recipe.getDawnstone(this.func_145831_w()) + " " + recipe.getCopper(this.func_145831_w()) + " " + recipe.getSilver(this.func_145831_w()) + " " + recipe.getLead(this.func_145831_w()));
            this.progress = 1;
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null) {
            player.func_184611_a(hand, this.getInventoryForFace(side).insertItem(0, heldItem, false));
            this.func_70296_d();
            if (!this.func_145831_w().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
            }
            return true;
        }
        if (this.getInventoryForFace(side).getStackInSlot(0) != null) {
            if (!this.func_145831_w().field_72995_K) {
                player.func_184611_a(hand, this.getInventoryForFace(side).extractItem(0, this.getInventoryForFace((EnumFacing)side).getStackInSlot((int)0).field_77994_a, false));
                this.func_70296_d();
                if (!this.func_145831_w().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.north);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.south);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.east);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.west);
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.center);
        world.func_175690_a(pos, null);
    }

    public List<TileEntityAlchemyPedestal> getNearbyPedestals() {
        ArrayList<TileEntityAlchemyPedestal> pedestals = new ArrayList<TileEntityAlchemyPedestal>();
        for (int i = -3; i < 4; ++i) {
            for (int j = -3; j < 4; ++j) {
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177982_a(i, 1, j));
                if (!(tile instanceof TileEntityAlchemyPedestal)) continue;
                pedestals.add((TileEntityAlchemyPedestal)tile);
            }
        }
        return pedestals;
    }

    public int getNearbyAsh(List<TileEntityAlchemyPedestal> pedestals) {
        int count = 0;
        for (TileEntityAlchemyPedestal pedestal : pedestals) {
            if (pedestal.inventory.getStackInSlot(0) == null) continue;
            count += pedestal.inventory.getStackInSlot((int)0).field_77994_a;
        }
        return count;
    }

    public void func_73660_a() {
        this.angle = (int)((float)this.angle + 1.0f);
        if (this.progress == 1) {
            int j;
            if (this.process < 20) {
                ++this.process;
            }
            List<TileEntityAlchemyPedestal> pedestals = this.getNearbyPedestals();
            if (this.func_145831_w().field_72995_K) {
                for (int i = 0; i < pedestals.size(); ++i) {
                    ParticleUtil.spawnParticleStar(this.func_145831_w(), (float)pedestals.get(i).func_174877_v().func_177958_n() + 0.5f, (float)pedestals.get(i).func_174877_v().func_177956_o() + 1.0f, (float)pedestals.get(i).func_174877_v().func_177952_p() + 0.5f, 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 3.5f + 0.5f * this.random.nextFloat(), 40);
                    for (j = 0; j < 8; ++j) {
                        float coeff = this.random.nextFloat();
                        float x = ((float)this.func_174877_v().func_177958_n() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestals.get(i).func_174877_v().func_177958_n() + 0.5f);
                        float y = ((float)this.func_174877_v().func_177956_o() + 0.875f) * coeff + (1.0f - coeff) * ((float)pedestals.get(i).func_174877_v().func_177956_o() + 1.0f);
                        float z = ((float)this.func_174877_v().func_177952_p() + 0.5f) * coeff + (1.0f - coeff) * ((float)pedestals.get(i).func_174877_v().func_177952_p() + 0.5f);
                        ParticleUtil.spawnParticleGlow(this.func_145831_w(), x, y, z, 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 0.0125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 2.0f, 24);
                    }
                }
            }
            if (this.angle % 10 == 0) {
                if (this.getNearbyAsh(pedestals) > 0) {
                    TileEntityAlchemyPedestal pedestal = pedestals.get(this.random.nextInt(pedestals.size()));
                    while (pedestal.inventory.extractItem(0, 1, true) == null) {
                        pedestal = pedestals.get(this.random.nextInt(pedestals.size()));
                    }
                    if (pedestal.inventory.getStackInSlot(1) != null) {
                        if (this.func_145831_w().field_72995_K) {
                            for (j = 0; j < 20; ++j) {
                                float dx = (float)this.func_174877_v().func_177958_n() + 0.5f - ((float)pedestal.func_174877_v().func_177958_n() + 0.5f);
                                float dy = (float)this.func_174877_v().func_177956_o() + 0.875f - ((float)pedestal.func_174877_v().func_177956_o() + 1.0f);
                                float dz = (float)this.func_174877_v().func_177952_p() + 0.5f - ((float)pedestal.func_174877_v().func_177952_p() + 0.5f);
                                float lifetime = this.random.nextFloat() * 24.0f + 24.0f;
                                ParticleUtil.spawnParticleStar(this.func_145831_w(), (float)pedestal.func_174877_v().func_177958_n() + 0.5f, (float)pedestal.func_174877_v().func_177956_o() + 1.0f, (float)pedestal.func_174877_v().func_177952_p() + 0.5f, dx / lifetime, dy / lifetime, dz / lifetime, 255.0f, 64.0f, 16.0f, 4.0f, (int)lifetime);
                            }
                        }
                        ItemStack stack = pedestal.inventory.extractItem(0, 1, false);
                        if (pedestal.inventory.getStackInSlot(1).func_77973_b() == RegistryManager.aspectusIron) {
                            ++this.iron;
                        }
                        if (pedestal.inventory.getStackInSlot(1).func_77973_b() == RegistryManager.aspectusDawnstone) {
                            ++this.dawnstone;
                        }
                        if (pedestal.inventory.getStackInSlot(1).func_77973_b() == RegistryManager.aspectusCopper) {
                            ++this.copper;
                        }
                        if (pedestal.inventory.getStackInSlot(1).func_77973_b() == RegistryManager.aspectusSilver) {
                            ++this.silver;
                        }
                        if (pedestal.inventory.getStackInSlot(1).func_77973_b() == RegistryManager.aspectusLead) {
                            ++this.lead;
                        }
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(pedestal));
                    }
                } else {
                    AlchemyRecipe recipe = RecipeRegistry.getAlchemyRecipe(this.center.getStackInSlot(0), this.east.getStackInSlot(0), this.west.getStackInSlot(0), this.north.getStackInSlot(0), this.south.getStackInSlot(0));
                    if (recipe != null && !this.func_145831_w().field_72995_K) {
                        ItemStack stack = recipe.getResult(this.func_145831_w(), this.iron, this.dawnstone, this.copper, this.silver, this.lead).func_77946_l();
                        if (!this.func_145831_w().field_72995_K) {
                            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)((float)this.func_174877_v().func_177956_o() + 1.0f), (double)this.func_174877_v().func_177952_p() + 0.5, stack));
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberSphereFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5));
                        }
                        this.progress = 0;
                        this.iron = 0;
                        this.dawnstone = 0;
                        this.copper = 0;
                        this.silver = 0;
                        this.lead = 0;
                        this.center.setStackInSlot(0, this.decrStack(this.center.getStackInSlot(0)));
                        this.north.setStackInSlot(0, this.decrStack(this.north.getStackInSlot(0)));
                        this.south.setStackInSlot(0, this.decrStack(this.south.getStackInSlot(0)));
                        this.east.setStackInSlot(0, this.decrStack(this.east.getStackInSlot(0)));
                        this.west.setStackInSlot(0, this.decrStack(this.west.getStackInSlot(0)));
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTEUpdate(this));
                    }
                }
            }
        }
        if (this.progress == 0 && this.process > 0) {
            --this.process;
        }
    }

    public ItemStack decrStack(ItemStack stack) {
        if (stack != null) {
            --stack.field_77994_a;
            if (stack.field_77994_a == 0) {
                return null;
            }
        }
        return stack;
    }
}

