/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import teamroots.embers.item.ItemAlchemicWaste;
import teamroots.embers.util.MatchUtil;

public class AlchemyRecipe {
    Random random = new Random();
    public int ironAspectMin = 0;
    public int dawnstoneAspectMin = 0;
    public int copperAspectMin = 0;
    public int silverAspectMin = 0;
    public int leadAspectMin = 0;
    public int ironAspectRange = 0;
    public int dawnstoneAspectRange = 0;
    public int copperAspectRange = 0;
    public int silverAspectRange = 0;
    public int leadAspectRange = 0;
    public List<ItemStack> inputs = new ArrayList<ItemStack>();
    public ItemStack centerInput = null;
    public ItemStack result = null;

    public AlchemyRecipe(int ironMin, int ironMax, int dawnstoneMin, int dawnstoneMax, int copperMin, int copperMax, int silverMin, int silverMax, int leadMin, int leadMax, ItemStack center, ItemStack east, ItemStack west, ItemStack north, ItemStack south, ItemStack result) {
        this.ironAspectMin = ironMin;
        this.ironAspectRange = ironMax - ironMin;
        this.dawnstoneAspectMin = dawnstoneMin;
        this.dawnstoneAspectRange = dawnstoneMax - dawnstoneMin;
        this.copperAspectMin = copperMin;
        this.copperAspectRange = copperMax - copperMin;
        this.silverAspectMin = silverMin;
        this.silverAspectRange = silverMax - silverMin;
        this.leadAspectMin = leadMin;
        this.leadAspectRange = leadMax - leadMin;
        this.centerInput = center;
        if (east != null) {
            this.inputs.add(east);
        }
        if (west != null) {
            this.inputs.add(west);
        }
        if (north != null) {
            this.inputs.add(north);
        }
        if (south != null) {
            this.inputs.add(south);
        }
        this.result = result;
    }

    public int getIron(World world) {
        this.random = new Random(world.func_72905_C());
        return this.ironAspectMin + this.random.nextInt(this.ironAspectRange + 1);
    }

    public int getDawnstone(World world) {
        this.random = new Random(world.func_72905_C());
        return this.dawnstoneAspectMin + this.random.nextInt(this.dawnstoneAspectRange + 1);
    }

    public int getCopper(World world) {
        this.random = new Random(world.func_72905_C());
        return this.copperAspectMin + this.random.nextInt(this.copperAspectRange + 1);
    }

    public int getSilver(World world) {
        this.random = new Random(world.func_72905_C());
        return this.silverAspectMin + this.random.nextInt(this.silverAspectRange + 1);
    }

    public int getLead(World world) {
        this.random = new Random(world.func_72905_C());
        return this.leadAspectMin + this.random.nextInt(this.leadAspectRange + 1);
    }

    public ItemStack getResult(World world, int iron, int dawnstone, int copper, int silver, int lead) {
        double dIron = Math.abs((double)(iron - this.getIron(world)));
        double dDawnstone = Math.abs((double)(dawnstone - this.getDawnstone(world)));
        double dCopper = Math.abs((double)(copper - this.getCopper(world)));
        double dSilver = Math.abs((double)(silver - this.getSilver(world)));
        double dLead = Math.abs((double)(lead - this.getLead(world)));
        double accuracy = Math.max(0.0, 1.0 - (dIron + dDawnstone + dCopper + dSilver + dLead) / (double)(this.getIron(world) + this.getDawnstone(world) + this.getCopper(world) + this.getSilver(world) + this.getLead(world)));
        if ((accuracy = (double)Math.round(accuracy * 100.0) / 100.0) == 1.0) {
            return this.result;
        }
        return ItemAlchemicWaste.create(accuracy * 100.0, iron + dawnstone + copper + silver + lead);
    }

    public boolean matches(ItemStack center, List<ItemStack> test) {
        if (ItemStack.func_179545_c((ItemStack)center, (ItemStack)this.centerInput)) {
            return MatchUtil.stackListsMatch(this.inputs, test);
        }
        return false;
    }
}

