/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.power;

import net.minecraft.nbt.NBTTagCompound;
import teamroots.embers.power.IStarlightCapability;

public class DefaultStarlightCapability
implements IStarlightCapability {
    private double starlight = 0.0;
    private double capacity = 0.0;

    @Override
    public double getStarlight() {
        return this.starlight;
    }

    @Override
    public double getStarlightCapacity() {
        return this.capacity;
    }

    @Override
    public void setStarlight(double value) {
        this.starlight = value;
    }

    @Override
    public void setStarlightCapacity(double value) {
        this.capacity = value;
    }

    @Override
    public double addAmount(double value, boolean doAdd) {
        if (this.starlight + value > this.capacity) {
            double added = this.capacity - this.starlight;
            if (doAdd) {
                this.starlight = this.capacity;
            }
            return added;
        }
        if (doAdd) {
            this.starlight += value;
        }
        return value;
    }

    @Override
    public double removeAmount(double value, boolean doRemove) {
        if (this.starlight - value < 0.0) {
            double removed = this.starlight;
            if (doRemove) {
                this.starlight = 0.0;
            }
            return removed;
        }
        if (doRemove) {
            this.starlight -= value;
        }
        return value;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74780_a("embers:ember", this.starlight);
        tag.func_74780_a("embers:emberCapacity", this.capacity);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("embers:ember")) {
            this.starlight = tag.func_74769_h("embers:ember");
        }
        if (tag.func_74764_b("embers:emberCapacity")) {
            this.capacity = tag.func_74769_h("embers:emberCapacity");
        }
    }
}

