/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.world.EmberWorldData;

public class MessageEmberGeneration
implements IMessage {
    String key = "";
    double ember = 0.0;

    public MessageEmberGeneration() {
    }

    public MessageEmberGeneration(String key, double ember) {
        this.key = key;
        this.ember = ember;
    }

    public void fromBytes(ByteBuf buf) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.ember = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        buf.writeDouble(this.ember);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageEmberGeneration, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageEmberGeneration message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (message.key != null) {
                    EmberWorldData data = EmberWorldData.get((World)Minecraft.func_71410_x().field_71441_e);
                    if (data.emberData.containsKey(message.key)) {
                        data.emberData.replace(message.key, message.ember);
                    } else {
                        data.emberData.put(message.key, message.ember);
                    }
                    data.func_76185_a();
                }
            });
            return null;
        }
    }
}

