/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberData;
import teamroots.embers.world.EmberWorldData;

public class MessageEmberDataRequest
implements IMessage {
    UUID id = null;
    int chunkCoordX = 0;
    int chunkCoordZ = 0;

    public MessageEmberDataRequest() {
    }

    public MessageEmberDataRequest(UUID id, int chunkCoordX, int chunkCoordZ) {
        this.id = id;
        this.chunkCoordX = chunkCoordX;
        this.chunkCoordZ = chunkCoordZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.chunkCoordX = buf.readInt();
        this.chunkCoordZ = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.chunkCoordX);
        buf.writeInt(this.chunkCoordZ);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageEmberDataRequest, IMessage> {
        public IMessage onMessage(MessageEmberDataRequest message, MessageContext ctx) {
            EmberWorldData data;
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(message.id);
            if (player != null && (data = EmberWorldData.get(player.func_130014_f_())) != null) {
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageEmberData(message.chunkCoordX, message.chunkCoordZ, data.getEmberForChunk(message.chunkCoordX, message.chunkCoordZ)), player);
            }
            return null;
        }
    }
}

