/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.EventManager;
import teamroots.embers.world.EmberWorldData;

public class MessageEmberData
implements IMessage {
    int chunkCoordX = 0;
    int chunkCoordZ = 0;
    double ember = 0.0;

    public MessageEmberData() {
    }

    public MessageEmberData(int chunkX, int chunkZ, double ember) {
        this.chunkCoordX = chunkX;
        this.chunkCoordZ = chunkZ;
        this.ember = ember;
    }

    public void fromBytes(ByteBuf buf) {
        this.chunkCoordX = buf.readInt();
        this.chunkCoordZ = buf.readInt();
        this.ember = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkCoordX);
        buf.writeInt(this.chunkCoordZ);
        buf.writeDouble(this.ember);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageEmberData, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageEmberData message, MessageContext ctx) {
            EmberWorldData.get(Minecraft.func_71410_x().field_71439_g.func_130014_f_()).setEmberForChunk(message.chunkCoordX, message.chunkCoordZ, message.ember);
            EmberWorldData.get(Minecraft.func_71410_x().field_71439_g.func_130014_f_()).func_76185_a();
            EventManager.currentEmber = message.ember;
            return null;
        }
    }
}

