/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.item.ItemBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageCannonBeamFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemIgnitionCannon
extends ItemBase {
    public ItemIgnitionCannon() {
        super("ignitionCannon", true);
        this.func_77625_d(1);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        double charge = (double)Math.min(20, timeLeft) / 20.0;
        double posX = entity.field_70165_t + entity.func_70040_Z().field_72450_a + (double)entity.field_70130_N / 2.0 * Math.sin(Math.toRadians(-entity.field_70177_z - 90.0f));
        double posY = entity.field_70163_u + (double)entity.func_70047_e() - 0.2 + entity.func_70040_Z().field_72448_b;
        double posZ = entity.field_70161_v + entity.func_70040_Z().field_72449_c + (double)entity.field_70130_N / 2.0 * Math.cos(Math.toRadians(-entity.field_70177_z - 90.0f));
        double targX = entity.field_70165_t + entity.func_70040_Z().field_72450_a * 96.0 + 30.0 * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
        double targY = entity.field_70163_u + entity.func_70040_Z().field_72448_b * 96.0 + 30.0 * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
        double targZ = entity.field_70161_v + entity.func_70040_Z().field_72449_c * 96.0 + 30.0 * (1.0 - charge) * ((double)field_77697_d.nextFloat() - 0.5);
        double dX = targX - posX;
        double dY = targY - posY;
        double dZ = targZ - posZ;
        boolean doContinue = true;
        if (!world.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageCannonBeamFX(entity.func_110124_au(), posX, posY, posZ, dX, dY, dZ));
        }
        for (double i = 0.0; i < 384.0 && doContinue; i += 1.0) {
            for (int j = 0; j < 5; ++j) {
                posX += 0.2 * i * dX / 384.0;
                posY += 0.2 * i * dY / 384.0;
                posZ += 0.2 * i * dZ / 384.0;
            }
            IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
            if (state.func_185917_h() && state.func_185914_p()) {
                doContinue = false;
            }
            List rawEntities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posX - 0.85, posY - 0.85, posZ - 0.85, posX + 0.85, posY + 0.85, posZ + 0.85));
            ArrayList entities = new ArrayList();
            for (int j = 0; j < rawEntities.size(); ++j) {
                if (((EntityLivingBase)rawEntities.get(j)).func_110124_au().compareTo(entity.func_110124_au()) == 0) continue;
                entities.add(rawEntities.get(j));
            }
            if (entities.size() <= 0) continue;
            ((EntityLivingBase)entities.get(0)).func_70015_d(1);
            ((EntityLivingBase)entities.get(0)).func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entity), 7.0f);
            ((EntityLivingBase)entities.get(0)).func_130011_c((Entity)entity);
            ((EntityLivingBase)entities.get(0)).func_70604_c(entity);
            ((EntityLivingBase)entities.get(0)).func_70653_a((Entity)entity, 0.5f, -dX, -dZ);
            doContinue = false;
        }
        stack.func_77978_p().func_74768_a("cooldown", 10);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
            stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            EmberInventoryUtil.removeEmber(player, 25.0);
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

