/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import teamroots.embers.Embers;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.IModeledItem;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemGrandhammer
extends ItemTool
implements IModeledItem,
IEmberChargedTool {
    public static Item.ToolMaterial materialGrandhammer = EnumHelper.addToolMaterial((String)"embers:grandhammer", (int)1, (int)-1, (float)6.0f, (float)6.0f, (int)15);

    public ItemGrandhammer(String name, boolean addToTab) {
        super(materialGrandhammer, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b}));
        this.func_77655_b(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.func_77637_a(Embers.tab);
        }
        this.setHarvestLevel("pickaxe", this.field_77862_b.func_77996_d());
        this.setHarvestLevel("axe", this.field_77862_b.func_77996_d());
        this.setHarvestLevel("shovel", this.field_77862_b.func_77996_d());
        this.field_77865_bY = 10.0f;
        this.field_185065_c = -3.0f;
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0) {
            return (float)stack.func_77978_p().func_74762_e("cooldown") / 160.0f;
        }
        return 0.0;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            int i;
            double posX = player.field_70165_t + 1.5 * player.func_70040_Z().field_72450_a;
            double posY = player.field_70163_u + (double)player.func_70047_e() + 1.5 * player.func_70040_Z().field_72448_b;
            double posZ = player.field_70161_v + 1.5 * player.func_70040_Z().field_72449_c;
            boolean doContinue = true;
            List rawEntities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(posX - 3.0, posY - 3.0, posZ - 3.0, posX + 3.0, posY + 3.0, posZ + 3.0));
            ArrayList entities = new ArrayList();
            for (i = 0; i < rawEntities.size(); ++i) {
                if (((EntityLivingBase)rawEntities.get(i)).func_110124_au().compareTo(player.func_110124_au()) == 0) continue;
                entities.add(rawEntities.get(i));
            }
            if (entities.size() > 0) {
                for (i = 0; i < entities.size(); ++i) {
                    ((EntityLivingBase)entities.get(i)).func_70015_d(1);
                    ((EntityLivingBase)entities.get(i)).func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 11.0f);
                    ((EntityLivingBase)entities.get(i)).func_130011_c((Entity)player);
                    ((EntityLivingBase)entities.get(i)).func_70604_c((EntityLivingBase)player);
                    ((EntityLivingBase)entities.get(i)).func_70653_a((Entity)player, 1.0f, player.field_70165_t - ((EntityLivingBase)entities.get((int)i)).field_70165_t, player.field_70161_v - ((EntityLivingBase)entities.get((int)i)).field_70161_v);
                    if (world.field_72995_K) continue;
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(((EntityLivingBase)entities.get((int)i)).field_70165_t, ((EntityLivingBase)entities.get((int)i)).field_70163_u + (double)((EntityLivingBase)entities.get(i)).func_70047_e() / 1.5, ((EntityLivingBase)entities.get((int)i)).field_70161_v));
                }
                stack.func_77978_p().func_74768_a("cooldown", 160);
                EmberInventoryUtil.removeEmber(player, 25.0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (stack.func_77942_o() && !stack.func_77978_p().func_74767_n("poweredOn")) {
            return 0.0f;
        }
        return this.field_77864_a;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getHarvestLevel(stack, state.func_177230_c().getHarvestTool(state)) >= state.func_177230_c().getHarvestLevel(state);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        stack.func_77978_p().func_74757_a("didUse", true);
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return slotChanged || oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("tickCount", 0);
            stack.func_77978_p().func_74757_a("poweredOn", false);
            stack.func_77978_p().func_74757_a("didUse", false);
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else {
            if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
            }
            if (entity instanceof EntityPlayer) {
                stack.func_77978_p().func_74768_a("tickCount", stack.func_77978_p().func_74762_e("tickCount") + 1);
                if (stack.func_77978_p().func_74762_e("tickCount") >= 5) {
                    stack.func_77978_p().func_74768_a("tickCount", 0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) > 5.0) {
                        if (!stack.func_77978_p().func_74767_n("poweredOn")) {
                            stack.func_77978_p().func_74757_a("poweredOn", true);
                        }
                    } else if (stack.func_77978_p().func_74767_n("poweredOn")) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
                if (stack.func_77978_p().func_74767_n("didUse")) {
                    stack.func_77978_p().func_74757_a("didUse", false);
                    EmberInventoryUtil.removeEmber((EntityPlayer)entity, 5.0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) < 5.0) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
            }
        }
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }
}

