/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.util.List;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import teamroots.embers.item.IEmberItem;
import teamroots.embers.item.IHeldEmberCell;
import teamroots.embers.item.ItemBase;

public class ItemEmberCartridge
extends ItemBase
implements IHeldEmberCell,
IEmberItem {
    public ItemEmberCartridge() {
        super("emberCartridge", true);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            this.setEmberCapacity(stack, 6000.0);
            this.setEmber(stack, 0.0);
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && this.getEmber(stack) < this.getEmberCapacity(stack);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> subItems) {
        ItemStack emptyStack = new ItemStack((Item)this, 1);
        emptyStack.func_77982_d(new NBTTagCompound());
        this.setEmberCapacity(emptyStack, 6000.0);
        this.setEmber(emptyStack, 0.0);
        subItems.add(emptyStack);
        ItemStack fullStack = new ItemStack((Item)this, 1);
        fullStack.func_77982_d(new NBTTagCompound());
        this.setEmberCapacity(fullStack, 6000.0);
        this.setEmber(fullStack, 6000.0);
        subItems.add(fullStack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o()) {
            return (this.getEmberCapacity(stack) - this.getEmber(stack)) / this.getEmberCapacity(stack);
        }
        return 0.0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (stack.func_77942_o()) {
            tooltip.add("" + this.getEmber(stack) + " / " + this.getEmberCapacity(stack));
        }
    }

    public void initNBT(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        this.setEmberCapacity(stack, 6000.0);
        this.setEmber(stack, 0.0);
    }

    @Override
    public double getEmber(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return stack.func_77978_p().func_74769_h("embers:ember");
    }

    @Override
    public double getEmberCapacity(ItemStack stack) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        return stack.func_77978_p().func_74769_h("embers:emberCapacity");
    }

    @Override
    public void setEmber(ItemStack stack, double value) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        stack.func_77978_p().func_74780_a("embers:ember", value);
    }

    @Override
    public void setEmberCapacity(ItemStack stack, double value) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        stack.func_77978_p().func_74780_a("embers:emberCapacity", value);
    }

    @Override
    public double addAmount(ItemStack stack, double value, boolean doAdd) {
        double capacity;
        double ember;
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        if ((ember = stack.func_77978_p().func_74769_h("embers:ember")) + value > (capacity = stack.func_77978_p().func_74769_h("embers:emberCapacity"))) {
            double added = capacity - ember;
            if (doAdd) {
                this.setEmber(stack, capacity);
                ember = capacity;
            }
            return added;
        }
        if (doAdd) {
            this.setEmber(stack, ember + value);
        }
        return value;
    }

    @Override
    public double removeAmount(ItemStack stack, double value, boolean doRemove) {
        if (!stack.func_77942_o()) {
            this.initNBT(stack);
        }
        double ember = stack.func_77978_p().func_74769_h("embers:ember");
        double capacity = stack.func_77978_p().func_74769_h("embers:emberCapacity");
        if (ember - value < 0.0) {
            double removed = ember;
            if (doRemove) {
                this.setEmber(stack, 0.0);
            }
            return removed;
        }
        if (doRemove) {
            this.setEmber(stack, ember - value);
        }
        return value;
    }

    public static class EmberChargeColorHandler
    implements IItemColor {
        public int func_186726_a(ItemStack stack, int layer) {
            if (layer == 0 && stack.func_77942_o() && stack.func_77973_b() instanceof IEmberItem) {
                double coeff = ((IEmberItem)stack.func_77973_b()).getEmber(stack) / ((IEmberItem)stack.func_77973_b()).getEmberCapacity(stack);
                int r = 255;
                int g = (int)(255.0 * (1.0 - coeff) + 64.0 * coeff);
                int b = (int)(255.0 * (1.0 - coeff) + 16.0 * coeff);
                return 0xFF0000;
            }
            return 0xFFFFFF;
        }
    }
}

