/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import teamroots.embers.Embers;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.IModeledItem;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemClockworkPickaxe
extends ItemTool
implements IModeledItem,
IEmberChargedTool {
    public static Item.ToolMaterial materialClockworkPickaxe = EnumHelper.addToolMaterial((String)"embers:clockworkPickaxe", (int)3, (int)-1, (float)12.0f, (float)4.0f, (int)15);

    public ItemClockworkPickaxe(String name, boolean addToTab) {
        super(materialClockworkPickaxe, (Set)Sets.newHashSet((Object[])new Block[]{Blocks.field_150348_b}));
        this.func_77655_b(name);
        this.setRegistryName("embers:" + name);
        if (addToTab) {
            this.func_77637_a(Embers.tab);
        }
        this.setHarvestLevel("pickaxe", this.field_77862_b.func_77996_d());
        this.setHarvestLevel("shovel", this.field_77862_b.func_77996_d());
        this.field_77865_bY = 6.0f;
        this.field_185065_c = -3.0f;
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("cooldown") > 0) {
            return (float)stack.func_77978_p().func_74762_e("cooldown") / 80.0f;
        }
        return 0.0;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            double posX = player.field_70165_t;
            double posY = player.field_70163_u + (double)player.func_70047_e();
            double posZ = player.field_70161_v;
            boolean doContinue = true;
            for (double i = 0.0; i < 40.0 && doContinue; i += 1.0) {
                for (int j = 0; j < 5; ++j) {
                    posX += (double)0.1f * player.func_70040_Z().field_72450_a;
                    posY += (double)0.1f * player.func_70040_Z().field_72448_b;
                    posZ += (double)0.1f * player.func_70040_Z().field_72449_c;
                }
                IBlockState state = world.func_180495_p(new BlockPos(posX, posY, posZ));
                if (!state.func_185917_h() || !state.func_185914_p()) continue;
                BlockPos blockPos = new BlockPos(posX, posY, posZ);
                if (!(state.func_185887_b(world, blockPos) > 0.0f)) continue;
                doContinue = false;
                BlockPos pos = new BlockPos(posX, posY, posZ);
                if (!world.field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5));
                }
                for (int xx = -1; xx < 2; ++xx) {
                    for (int yy = -1; yy < 2; ++yy) {
                        for (int zz = -1; zz < 2; ++zz) {
                            BlockPos newPos = pos.func_177982_a(xx, yy, zz);
                            if (!this.canHarvestBlock(world.func_180495_p(newPos), stack)) continue;
                            BlockPos blockPos2 = new BlockPos(posX, posY, posZ);
                            if (!(world.func_180495_p(newPos).func_185887_b(world, blockPos2) > 0.0f)) continue;
                            IBlockState tempState = world.func_180495_p(newPos);
                            tempState.func_177230_c().func_176208_a(world, newPos, tempState, player);
                            world.func_175655_b(newPos, true);
                            world.func_184138_a(newPos, state, Blocks.field_150350_a.func_176223_P(), 3);
                        }
                    }
                }
                stack.func_77978_p().func_74768_a("cooldown", 80);
                EmberInventoryUtil.removeEmber(player, 25.0);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        if (stack.func_77942_o() && !stack.func_77978_p().func_74767_n("poweredOn")) {
            return 0.0f;
        }
        return material != Material.field_151576_e && material != Material.field_151592_s && material != Material.field_151577_b && material != Material.field_151594_q && material != Material.field_151574_g && material != Material.field_151573_f && material != Material.field_151578_c && material != Material.field_151571_B && material != Material.field_151595_p && material != Material.field_151597_y && material != Material.field_151588_w && material != Material.field_151598_x && material != Material.field_76233_E ? super.func_150893_a(stack, state) : this.field_77864_a;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        stack.func_77978_p().func_74757_a("didUse", true);
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getHarvestLevel(stack, state.func_177230_c().getHarvestTool(state)) >= state.func_177230_c().getHarvestLevel(state);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return slotChanged || oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return slotChanged;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.func_77942_o() && newStack.func_77942_o()) {
            return oldStack.func_77978_p().func_74767_n("poweredOn") != newStack.func_77978_p().func_74767_n("poweredOn");
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("tickCount", 0);
            stack.func_77978_p().func_74757_a("poweredOn", false);
            stack.func_77978_p().func_74757_a("didUse", false);
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else {
            if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
                stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
            }
            if (entity instanceof EntityPlayer) {
                stack.func_77978_p().func_74768_a("tickCount", stack.func_77978_p().func_74762_e("tickCount") + 1);
                if (stack.func_77978_p().func_74762_e("tickCount") >= 5) {
                    stack.func_77978_p().func_74768_a("tickCount", 0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) > 5.0) {
                        if (!stack.func_77978_p().func_74767_n("poweredOn")) {
                            stack.func_77978_p().func_74757_a("poweredOn", true);
                        }
                    } else if (stack.func_77978_p().func_74767_n("poweredOn")) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
                if (stack.func_77978_p().func_74767_n("didUse")) {
                    stack.func_77978_p().func_74757_a("didUse", false);
                    EmberInventoryUtil.removeEmber((EntityPlayer)entity, 5.0);
                    if (EmberInventoryUtil.getEmberTotal((EntityPlayer)entity) < 5.0) {
                        stack.func_77978_p().func_74757_a("poweredOn", false);
                    }
                }
            }
        }
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString()));
    }
}

