/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.entity.EntityEmberProjectile;
import teamroots.embers.item.ItemBase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.EmberInventoryUtil;

public class ItemCinderStaff
extends ItemBase {
    public ItemCinderStaff() {
        super("staffEmber", true);
        this.func_77625_d(1);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            double charge = (double)Math.min(60, 72000 - timeLeft) / 60.0 * 17.0;
            float spawnDistance = 2.0f;
            EntityEmberProjectile proj = new EntityEmberProjectile(world);
            proj.initCustom(entity.field_70165_t + entity.func_70040_Z().field_72450_a * (double)spawnDistance, entity.field_70163_u + (double)entity.func_70047_e() + entity.func_70040_Z().field_72448_b * (double)spawnDistance, entity.field_70161_v + entity.func_70040_Z().field_72449_c * (double)spawnDistance, entity.func_70040_Z().field_72450_a * 0.85, entity.func_70040_Z().field_72448_b * 0.85, entity.func_70040_Z().field_72449_c * 0.85, charge, entity.func_110124_au());
            world.func_72838_d((Entity)proj);
        }
        stack.func_77978_p().func_74768_a("cooldown", 10);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74768_a("cooldown", 0);
        } else if (stack.func_77978_p().func_74762_e("cooldown") > 0) {
            stack.func_77978_p().func_74768_a("cooldown", stack.func_77978_p().func_74762_e("cooldown") - 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        double charge = (double)Math.min(60, 72000 - count) / 60.0 * 15.0;
        for (int i = 0; i < 4; ++i) {
            float spawnDistance = 2.0f;
            ParticleUtil.spawnParticleGlow(player.func_130014_f_(), (float)player.field_70165_t + spawnDistance * (float)player.func_70040_Z().field_72450_a + (field_77697_d.nextFloat() * 0.1f - 0.05f), (float)player.field_70163_u + player.func_70047_e() + spawnDistance * (float)player.func_70040_Z().field_72448_b + (field_77697_d.nextFloat() * 0.1f - 0.05f), (float)player.field_70161_v + spawnDistance * (float)player.func_70040_Z().field_72449_c + (field_77697_d.nextFloat() * 0.1f - 0.05f), 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, (float)charge / 1.75f, 24);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (EmberInventoryUtil.getEmberTotal(player) >= 25.0 && stack.func_77978_p().func_74762_e("cooldown") <= 0 || player.field_71075_bZ.field_75098_d) {
            EmberInventoryUtil.removeEmber(player, 25.0);
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

