/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.compat.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import teamroots.embers.compat.jei.AlchemyRecipeWrapper;
import teamroots.embers.recipe.AlchemyRecipe;

public class AlchemyRecipeCategory
extends BlankRecipeCategory {
    private final IDrawable background;
    private final IDrawable ashBar;
    private final IDrawable ashPartialBar;
    private final String name;
    private IGuiHelper helper = null;
    private AlchemyRecipe lastRecipe = null;
    public static ResourceLocation texture = new ResourceLocation("embers:textures/gui/jeiAlchemy.png");

    public AlchemyRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(texture, 0, 0, 108, 132);
        this.ashBar = helper.createDrawable(texture, 109, 1, 52, 8);
        this.ashPartialBar = helper.createDrawable(texture, 109, 10, 52, 8);
        this.name = I18n.func_135052_a((String)"embers.jei.recipe.alchemy", (Object[])new Object[0]);
    }

    public String getTitle() {
        return this.name;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getUid() {
        return "embers.alchemy";
    }

    public void setRecipe(IRecipeLayout layout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 27, 18);
        stacks.init(1, true, 9, 18);
        stacks.init(2, true, 27, 0);
        stacks.init(3, true, 45, 18);
        stacks.init(4, true, 27, 36);
        stacks.init(5, true, 81, 18);
        for (int i = 0; i < 5; ++i) {
            if (ingredients.getInputs(ItemStack.class).size() <= i || ingredients.getInputs(ItemStack.class).get(i) == null) continue;
            stacks.set(i, (List)ingredients.getInputs(ItemStack.class).get(i));
        }
        if (ingredients.getOutputs(ItemStack.class).size() > 0) {
            stacks.set(5, (ItemStack)ingredients.getOutputs(ItemStack.class).get(0));
        }
        if (recipeWrapper instanceof AlchemyRecipeWrapper) {
            this.lastRecipe = ((AlchemyRecipeWrapper)recipeWrapper).recipe;
        }
    }

    public void drawExtras(Minecraft minecraft) {
        IDrawableStatic ashPartialBar;
        IDrawableStatic ashBar;
        super.drawExtras(minecraft);
        int aspectTotal = this.lastRecipe.ironAspectMin + this.lastRecipe.ironAspectRange + this.lastRecipe.copperAspectMin + this.lastRecipe.copperAspectRange + this.lastRecipe.silverAspectMin + this.lastRecipe.silverAspectRange + this.lastRecipe.leadAspectMin + this.lastRecipe.leadAspectRange + this.lastRecipe.dawnstoneAspectMin + this.lastRecipe.dawnstoneAspectRange;
        if (this.lastRecipe.ironAspectMin + this.lastRecipe.ironAspectRange > 0) {
            ashBar = this.helper.createDrawable(texture, 109, 1, 52 * this.lastRecipe.ironAspectMin / aspectTotal, 8);
            ashPartialBar = this.helper.createDrawable(texture, 109, 11, 52 * (this.lastRecipe.ironAspectMin + this.lastRecipe.ironAspectRange) / aspectTotal, 8);
            ashPartialBar.draw(minecraft, 17, 61);
            ashBar.draw(minecraft, 17, 61);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("" + this.lastRecipe.ironAspectMin + "-" + (this.lastRecipe.ironAspectMin + this.lastRecipe.ironAspectRange), 75.0f, 61.0f, 0xFFFFFF);
        }
        if (this.lastRecipe.copperAspectMin + this.lastRecipe.copperAspectRange > 0) {
            ashBar = this.helper.createDrawable(texture, 109, 1, 52 * this.lastRecipe.copperAspectMin / aspectTotal, 8);
            ashPartialBar = this.helper.createDrawable(texture, 109, 11, 52 * (this.lastRecipe.copperAspectMin + this.lastRecipe.copperAspectRange) / aspectTotal, 8);
            ashPartialBar.draw(minecraft, 17, 76);
            ashBar.draw(minecraft, 17, 76);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("" + this.lastRecipe.copperAspectMin + "-" + (this.lastRecipe.copperAspectMin + this.lastRecipe.copperAspectRange), 75.0f, 76.0f, 0xFFFFFF);
        }
        if (this.lastRecipe.dawnstoneAspectMin + this.lastRecipe.dawnstoneAspectRange > 0) {
            ashBar = this.helper.createDrawable(texture, 109, 1, 52 * this.lastRecipe.dawnstoneAspectMin / aspectTotal, 8);
            ashPartialBar = this.helper.createDrawable(texture, 109, 11, 52 * (this.lastRecipe.dawnstoneAspectMin + this.lastRecipe.dawnstoneAspectRange) / aspectTotal, 8);
            ashPartialBar.draw(minecraft, 17, 91);
            ashBar.draw(minecraft, 17, 91);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("" + this.lastRecipe.dawnstoneAspectMin + "-" + (this.lastRecipe.dawnstoneAspectMin + this.lastRecipe.dawnstoneAspectRange), 75.0f, 91.0f, 0xFFFFFF);
        }
        if (this.lastRecipe.leadAspectMin + this.lastRecipe.leadAspectRange > 0) {
            ashBar = this.helper.createDrawable(texture, 109, 1, 52 * this.lastRecipe.leadAspectMin / aspectTotal, 8);
            ashPartialBar = this.helper.createDrawable(texture, 109, 11, 52 * (this.lastRecipe.leadAspectMin + this.lastRecipe.leadAspectRange) / aspectTotal, 8);
            ashPartialBar.draw(minecraft, 17, 106);
            ashBar.draw(minecraft, 17, 106);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("" + this.lastRecipe.leadAspectMin + "-" + (this.lastRecipe.leadAspectMin + this.lastRecipe.leadAspectRange), 75.0f, 106.0f, 0xFFFFFF);
        }
        if (this.lastRecipe.silverAspectMin + this.lastRecipe.silverAspectRange > 0) {
            ashBar = this.helper.createDrawable(texture, 109, 1, 52 * this.lastRecipe.silverAspectMin / aspectTotal, 8);
            ashPartialBar = this.helper.createDrawable(texture, 109, 11, 52 * (this.lastRecipe.silverAspectMin + this.lastRecipe.silverAspectRange) / aspectTotal, 8);
            ashPartialBar.draw(minecraft, 17, 121);
            ashBar.draw(minecraft, 17, 121);
            Minecraft.func_71410_x().field_71466_p.func_175063_a("" + this.lastRecipe.silverAspectMin + "-" + (this.lastRecipe.silverAspectMin + this.lastRecipe.silverAspectRange), 75.0f, 121.0f, 0xFFFFFF);
        }
    }
}

