/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.IDial;
import teamroots.embers.item.IEmberChargedTool;
import teamroots.embers.item.ItemAshenCloak;
import teamroots.embers.item.ItemEmberGauge;
import teamroots.embers.item.ItemGolemsEye;
import teamroots.embers.item.ItemGrandhammer;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageEmberDataRequest;
import teamroots.embers.proxy.ClientProxy;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.research.ResearchManager;
import teamroots.embers.tileentity.ITileEntitySpecialRendererLater;
import teamroots.embers.tileentity.TileEntityKnowledgeTable;
import teamroots.embers.util.BlockTextureUtil;
import teamroots.embers.util.FluidTextureUtil;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.world.EmberWorldData;

public class EventManager {
    double gaugeAngle = 0.0;
    public static boolean hasRenderedParticles = false;
    Random random = new Random();
    public static float emberEyeView = 0.0f;
    public static ResearchBase lastResearch = null;
    public static float frameTime = 0.0f;
    public static float frameCounter = 0.0f;
    public static long prevTime = 0L;
    public static EnumHand lastHand = EnumHand.MAIN_HAND;
    public static float starlightRed = 255.0f;
    public static float starlightGreen = 32.0f;
    public static float starlightBlue = 255.0f;
    public static float tickCounter = 0.0f;
    public static double currentEmber = 0.0;
    static EntityPlayer clientPlayer = null;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchPre(TextureStitchEvent.Pre event) {
        FluidTextureUtil.initTextures(event.getMap());
        BlockTextureUtil.mapBlockTexture(event.getMap(), new ResourceLocation("embers:textures/blocks/pipeTex.png"));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        ResourceLocation particleGlow = new ResourceLocation("embers:entity/particleMote");
        event.getMap().func_174942_a(particleGlow);
        ResourceLocation particleSparkle = new ResourceLocation("embers:entity/particleStar");
        event.getMap().func_174942_a(particleSparkle);
        ResourceLocation particleSmoke = new ResourceLocation("embers:entity/particleSmoke");
        event.getMap().func_174942_a(particleSmoke);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        EmberWorldData.get(event.getWorld());
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            String source = event.getSource().func_76355_l();
            if (source.compareTo("mob") != 0 && source.compareTo("generic") != 0 && source.compareTo("player") != 0 && source.compareTo("arrow") != 0) {
                if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == RegistryManager.inflictorGem && player.func_184614_ca().func_77942_o()) {
                    player.func_184614_ca().func_77964_b(1);
                    player.func_184614_ca().func_77978_p().func_74778_a("type", event.getSource().func_76355_l());
                }
                if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == RegistryManager.inflictorGem && player.func_184592_cb().func_77942_o()) {
                    player.func_184592_cb().func_77964_b(1);
                    player.func_184592_cb().func_77978_p().func_74778_a("type", event.getSource().func_76355_l());
                }
            }
        }
        if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD) != null && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST) != null && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS) != null && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET) != null && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemAshenCloak && event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemAshenCloak) {
            float mult = Math.max(0.0f, 1.0f - ItemAshenCloak.getDamageMultiplier(event.getSource(), event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST)));
            if (mult == 0.0f) {
                event.setCanceled(true);
            }
            event.setAmount(event.getAmount() * mult);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        IBlockState state;
        World world;
        if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            frameCounter += 1.0f;
            frameTime = (float)(System.nanoTime() - prevTime) / 1.0E9f;
            prevTime = System.nanoTime();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean showBar = false;
        int w = e.getResolution().func_78326_a();
        int h = e.getResolution().func_78328_b();
        int x = w / 2;
        int y = h / 2;
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemEmberGauge) {
            showBar = true;
        }
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer b = tess.func_178180_c();
        if (showBar) {
            world = player.func_130014_f_();
            if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                GlStateManager.func_179094_E();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/emberMeterOverlay.png"));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean offsetX = false;
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, x - 16, y - 4, x + 16, y - 4, x + 16, y - 36, x - 16, y - 36, 0, 0, 1, 1);
                tess.func_78381_a();
                double angle = 195.0;
                EmberWorldData data = EmberWorldData.get(world);
                if (player != null) {
                    double ratio = data.getEmberForChunk((int)Math.floor((float)player.func_180425_c().func_177958_n() / 16.0f), (int)Math.floor((float)player.func_180425_c().func_177952_p() / 16.0f)) / 822000.0;
                    this.gaugeAngle = this.gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : this.gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/emberMeterPointer.png"));
                GlStateManager.func_179109_b((float)x, (float)(y - 20), (float)0.0f);
                GlStateManager.func_179114_b((float)((float)this.gaugeAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, -2.5f, 13.5f, 13.5f, 13.5f, 13.5f, -2.5f, -2.5f, -2.5f, 0, 0, 1, 1);
                tess.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179126_j();
            }
        }
        world = player.func_130014_f_();
        RayTraceResult result = player.func_174822_a(6.0, e.getPartialTicks());
        boolean showEye = false;
        boolean showingResearch = false;
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemGolemsEye) {
            showEye = true;
            lastHand = EnumHand.OFF_HAND;
        }
        if (player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemGolemsEye) {
            showEye = true;
            lastHand = EnumHand.MAIN_HAND;
        }
        if (showEye && result != null) {
            ResearchBase research;
            ItemStack test = null;
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                if (world.func_175625_s(result.func_178782_a()) instanceof TileEntityKnowledgeTable) {
                    TileEntityKnowledgeTable table = (TileEntityKnowledgeTable)world.func_175625_s(result.func_178782_a());
                    if (table.inventory.getStackInSlot(0) != null) {
                        test = table.inventory.getStackInSlot(0);
                    }
                }
                if (test == null) {
                    test = new ItemStack(world.func_180495_p(result.func_178782_a()).func_177230_c(), 1, world.func_180495_p(result.func_178782_a()).func_177230_c().func_176201_c(world.func_180495_p(result.func_178782_a())));
                }
            }
            if (test != null && test.func_77973_b() != null && (research = ResearchManager.researches.get(test.func_77973_b().getRegistryName().toString())) != null) {
                lastResearch = research;
                showingResearch = true;
                if (emberEyeView < 1.0f) {
                    emberEyeView += 0.2f * frameTime;
                }
                if (emberEyeView > 1.0f) {
                    emberEyeView = 1.0f;
                }
            }
        }
        if (!showingResearch && emberEyeView > 0.0f) {
            emberEyeView -= 0.2f * frameTime;
        }
        if (emberEyeView < 0.0f) {
            emberEyeView = 0.0f;
        }
        if (emberEyeView > 0.0f && lastResearch != null && e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            x = lastHand == EnumHand.MAIN_HAND ? w - 85 : 85;
            int func = GL11.glGetInteger((int)3009);
            float ref = GL11.glGetFloat((int)3010);
            GlStateManager.func_179092_a((int)519, (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/gradient.png"));
            GlStateManager.func_179131_c((float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(0.8f * emberEyeView));
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int i = 0; i < 36; ++i) {
                float xCur = (float)((double)x + 150.0 * Math.cos(Math.toRadians(i * 10)));
                float yCur = (float)((double)y + 150.0 * Math.sin(Math.toRadians(i * 10)));
                float xNext = (float)((double)x + 150.0 * Math.cos(Math.toRadians(i * 10 + 10)));
                float yNext = (float)((double)y + 150.0 * Math.sin(Math.toRadians(i * 10 + 10)));
                RenderUtil.drawQuadGuiExt(b, x, y, x, y, xCur, yCur, xNext, yNext, 0, 0, 256, 256, 256, 256);
            }
            tess.func_78381_a();
            Random rand = new Random();
            rand.setSeed("embers".hashCode());
            GlStateManager.func_179131_c((float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(0.3f * emberEyeView));
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            for (int j = 0; j < 80; ++j) {
                float shiftAngle = rand.nextFloat() * 360.0f;
                float rate = rand.nextFloat() + 0.5f;
                int reversed = (int)Math.signum(rand.nextFloat() - 0.5f);
                float radius = rand.nextFloat() * 100.0f;
                float bubbleScale = 0.4f + 2.0f * ((100.0f - radius) / 100.0f);
                float baseX = (float)x + radius * (float)Math.cos(Math.toRadians((float)reversed * rate * (frameCounter + shiftAngle)));
                float baseY = (float)y + radius * (float)Math.sin(Math.toRadians((float)reversed * rate * (frameCounter + shiftAngle)));
                for (int i = 0; i < 10; ++i) {
                    float xCur = (float)((double)baseX + (double)(bubbleScale * 20.0f) * Math.cos(Math.toRadians(i * 36)));
                    float yCur = (float)((double)baseY + (double)(bubbleScale * 20.0f) * Math.sin(Math.toRadians(i * 36)));
                    float xNext = (float)((double)baseX + (double)(bubbleScale * 20.0f) * Math.cos(Math.toRadians(i * 36 + 36)));
                    float yNext = (float)((double)baseY + (double)(bubbleScale * 20.0f) * Math.sin(Math.toRadians(i * 36 + 36)));
                    RenderUtil.drawQuadGuiExt(b, baseX, baseY, baseX, baseY, xCur, yCur, xNext, yNext, 0, 0, 256, 128, 256, 256);
                }
            }
            tess.func_78381_a();
            GlStateManager.func_179131_c((float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView), (float)(1.0f * emberEyeView));
            Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/eyeGuiOverlay.png"));
            b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            RenderUtil.drawQuadGuiExt(b, x - 16, y - 48, x + 16, y - 48, x + 16, y - 80, x - 16, y - 80, 0, 0, 32, 32, 128, 128);
            tess.func_78381_a();
            GlStateManager.func_179126_j();
            GlStateManager.func_179140_f();
            RenderHelper.func_74518_a();
            RenderHelper.func_74520_c();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(EventManager.lastResearch.icon, x - 8, y - 72);
            RenderHelper.func_74519_b();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            ArrayList<String> text = lastResearch.getLines();
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int yOff = -44;
            font.func_175063_a(lastResearch.getTitle(), (float)(x - font.func_78256_a(lastResearch.getTitle()) / 2), (float)(y + yOff), (int)(255.0f * emberEyeView) << 24 | 0xFF330F);
            yOff += 1 + font.field_78288_b;
            GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.0);
            if ((int)(255.0f * emberEyeView) > 0) {
                for (int i = 0; i < text.size(); ++i) {
                    font.func_175063_a(text.get(i), 2.0f * (float)(x - font.func_78256_a(text.get(i)) / 4), 2.0f * (float)(y + yOff + i * (font.field_78288_b / 2 + 1)), (int)(255.0f * emberEyeView) << 24 | 0xFF330F);
                }
            }
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)0.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)func, (float)ref);
            x = w / 2;
        }
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IDial) {
            List<String> text = ((IDial)state.func_177230_c()).getDisplayInfo(world, result.func_178782_a(), state);
            for (int i = 0; i < text.size(); ++i) {
                Minecraft.func_71410_x().field_71466_p.func_175063_a(text.get(i), (float)(x - Minecraft.func_71410_x().field_71466_p.func_78256_a(text.get(i)) / 2), (float)(y + 40 + 11 * i), 0xFFFFFF);
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft:textures/gui/icons.png"));
        GlStateManager.func_179126_j();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            ++EmberWorldData.get((World)event.world).ticks;
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageEmberDataRequest(Minecraft.func_71410_x().field_71439_g.func_110124_au(), (int)Math.floor((float)Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177958_n() / 16.0f), (int)Math.floor((float)Minecraft.func_71410_x().field_71439_g.func_180425_c().func_177952_p() / 16.0f)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT) {
            ClientProxy.particleRenderer.updateParticles();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().field_76373_n == RegistryManager.damageEmber.field_76373_n && event.getEntityLiving().func_70644_a(Potion.func_180142_b((String)"fire_resistance"))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof EntityPlayer && ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca() != null && ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77973_b() instanceof IEmberChargedTool) {
            if (IEmberChargedTool.hasEmber(((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()) || ((EntityPlayer)event.getSource().func_76346_g()).field_71075_bZ.field_75098_d) {
                event.getEntityLiving().func_70015_d(1);
                if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().func_70047_e() / 1.5, event.getEntityLiving().field_70161_v));
                    ((EntityPlayer)event.getSource().func_76346_g()).func_184614_ca().func_77978_p().func_74757_a("didUse", true);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && event.getPlayer().func_184614_ca() != null && event.getPlayer().func_184614_ca().func_77973_b() instanceof ItemGrandhammer) {
            event.setCanceled(true);
            event.getWorld().func_175698_g(event.getPos());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderAfterWorld(RenderWorldLastEvent event) {
        starlightBlue = 96.0f + 80.0f * (float)(Math.sin(Math.toRadians((tickCounter += 1.0f) % 360.0f)) + 1.0);
        starlightRed = 255.0f - 80.0f * (float)(Math.sin(Math.toRadians(tickCounter % 360.0f)) + 1.0);
        if (Embers.proxy instanceof ClientProxy) {
            ClientProxy.particleRenderer.renderParticles(clientPlayer, event.getPartialTicks());
        }
        List list = Minecraft.func_71410_x().field_71441_e.field_147482_g;
        for (int i = 0; i < list.size(); ++i) {
            TileEntitySpecialRenderer render = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)list.get(i));
            if (!(render instanceof ITileEntitySpecialRendererLater)) continue;
            double x = Minecraft.func_71410_x().field_71439_g.field_70142_S + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S);
            double y = Minecraft.func_71410_x().field_71439_g.field_70137_T + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T);
            double z = Minecraft.func_71410_x().field_71439_g.field_70136_U + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U);
            ((ITileEntitySpecialRendererLater)render).renderLater((TileEntity)list.get(i), (double)((TileEntity)list.get(i)).func_174877_v().func_177958_n() - x, (double)((TileEntity)list.get(i)).func_174877_v().func_177956_o() - y, (double)((TileEntity)list.get(i)).func_174877_v().func_177952_p() - z, Minecraft.func_71410_x().func_184121_ak());
        }
    }
}

