/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.block.networking.BlockCableBus;
import appeng.block.paint.BlockPaint;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.IBlockTool;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;

public class ToolColorApplicator
extends AEBasePoweredItem
implements IStorageCell,
IItemGroup,
IBlockTool,
IMouseWheelItem {
    private static final Map<Integer, AEColor> ORE_TO_COLOR = new HashMap<Integer, AEColor>();

    public ToolColorApplicator() {
        super(AEConfig.instance().getColorApplicatorBattery());
    }

    public EnumActionResult func_180614_a(ItemStack is, EntityPlayer p, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block blk = w.func_180495_p(pos).func_177230_c();
        ItemStack paintBall = this.getColor(is);
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            AEColor color;
            IAEItemStack option = inv.extractItems(AEItemStack.create(paintBall), Actionable.SIMULATE, new BaseActionSource());
            if (option != null) {
                paintBall = option.getItemStack();
                paintBall.field_77994_a = 1;
            } else {
                paintBall = null;
            }
            if (!Platform.hasPermissions(new DimensionalCoord(w, pos), p)) {
                return EnumActionResult.FAIL;
            }
            double powerPerUse = 100.0;
            if (paintBall != null && paintBall.func_77973_b() instanceof ItemSnowball) {
                TileEntity te = w.func_175625_s(pos);
                if (te instanceof IColorableTile && this.getAECurrentPower(is) > 100.0 && ((IColorableTile)te).getColor() != AEColor.TRANSPARENT && ((IColorableTile)te).recolourBlock(side, AEColor.TRANSPARENT, p)) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0);
                    return EnumActionResult.SUCCESS;
                }
                Block testBlk = w.func_180495_p(pos.func_177972_a(side)).func_177230_c();
                TileEntity painted = w.func_175625_s(pos.func_177972_a(side));
                if (this.getAECurrentPower(is) > 100.0 && testBlk instanceof BlockPaint && painted instanceof TilePaint) {
                    inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                    this.extractAEPower(is, 100.0);
                    ((TilePaint)painted).cleanSide(side.func_176734_d());
                    return EnumActionResult.SUCCESS;
                }
            } else if (paintBall != null && (color = this.getColorFromItem(paintBall)) != null && this.getAECurrentPower(is) > 100.0 && color != AEColor.TRANSPARENT && this.recolourBlock(blk, side, w, pos, side, color, p)) {
                inv.extractItems(AEItemStack.create(paintBall), Actionable.MODULATE, new BaseActionSource());
                this.extractAEPower(is, 100.0);
                return EnumActionResult.SUCCESS;
            }
        }
        if (p.func_70093_af()) {
            this.cycleColors(is, paintBall, 1);
        }
        return EnumActionResult.FAIL;
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        String extra = GuiText.Empty.getLocal();
        AEColor selected = this.getActiveColor(par1ItemStack);
        if (selected != null && Platform.isClient()) {
            extra = Platform.gui_localize(selected.unlocalizedName);
        }
        return super.func_77653_i(par1ItemStack) + " - " + extra;
    }

    public AEColor getActiveColor(ItemStack tol) {
        return this.getColorFromItem(this.getColor(tol));
    }

    private AEColor getColorFromItem(ItemStack paintBall) {
        int[] id;
        if (paintBall == null) {
            return null;
        }
        if (paintBall.func_77973_b() instanceof ItemSnowball) {
            return AEColor.TRANSPARENT;
        }
        if (paintBall.func_77973_b() instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)paintBall.func_77973_b();
            return ipb.getColor(paintBall);
        }
        for (int oreID : id = OreDictionary.getOreIDs((ItemStack)paintBall)) {
            if (!ORE_TO_COLOR.containsKey(oreID)) continue;
            return ORE_TO_COLOR.get(oreID);
        }
        return null;
    }

    public ItemStack getColor(ItemStack is) {
        NBTTagCompound color;
        ItemStack oldColor;
        NBTTagCompound c = is.func_77978_p();
        if (c != null && c.func_74764_b("color") && (oldColor = ItemStack.func_77949_a((NBTTagCompound)(color = c.func_74775_l("color")))) != null) {
            return oldColor;
        }
        return this.findNextColor(is, null, 0);
    }

    private ItemStack findNextColor(ItemStack is, ItemStack anchor, int scrollOffset) {
        ItemStack newColor = null;
        IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS);
        if (inv != null) {
            IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
            if (anchor == null) {
                IAEItemStack firstItem = itemList.getFirstItem();
                if (firstItem != null) {
                    newColor = firstItem.getItemStack();
                }
            } else {
                LinkedList<IAEItemStack> list = new LinkedList<IAEItemStack>();
                for (IAEItemStack i : itemList) {
                    list.add(i);
                }
                Collections.sort(list, new Comparator<IAEItemStack>(){

                    @Override
                    public int compare(IAEItemStack a, IAEItemStack b) {
                        return ItemSorters.compareInt(a.getItemDamage(), b.getItemDamage());
                    }
                });
                if (list.size() <= 0) {
                    return null;
                }
                IAEItemStack where = (IAEItemStack)list.getFirst();
                for (int cycles = 1 + list.size(); cycles > 0 && !where.equals(anchor); --cycles) {
                    list.addLast((IAEItemStack)list.removeFirst());
                    where = (IAEItemStack)list.getFirst();
                }
                if (scrollOffset > 0) {
                    list.addLast((IAEItemStack)list.removeFirst());
                }
                if (scrollOffset < 0) {
                    list.addFirst((IAEItemStack)list.removeLast());
                }
                return ((IAEItemStack)list.get(0)).getItemStack();
            }
        }
        if (newColor != null) {
            this.setColor(is, newColor);
        }
        return newColor;
    }

    private void setColor(ItemStack is, ItemStack newColor) {
        NBTTagCompound data = Platform.openNbtData(is);
        if (newColor == null) {
            data.func_82580_o("color");
        } else {
            NBTTagCompound color = new NBTTagCompound();
            newColor.func_77955_b(color);
            data.func_74782_a("color", (NBTBase)color);
        }
    }

    private boolean recolourBlock(Block blk, EnumFacing side, World w, BlockPos pos, EnumFacing orientation, AEColor newColor, EntityPlayer p) {
        IBlockState state = w.func_180495_p(pos);
        if (blk instanceof BlockColored) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockColored.field_176581_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150359_w) {
            return w.func_175656_a(pos, Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150399_cn) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlass.field_176547_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150410_aZ) {
            return w.func_175656_a(pos, Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150397_co) {
            EnumDyeColor color = (EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a);
            if (newColor.dye == color) {
                return false;
            }
            return w.func_175656_a(pos, state.func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)newColor.dye));
        }
        if (blk == Blocks.field_150405_ch) {
            return w.func_175656_a(pos, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)newColor.dye));
        }
        if (blk instanceof BlockCableBus) {
            return ((BlockCableBus)blk).recolorBlock(w, pos, side, newColor.dye, p);
        }
        return blk.recolorBlock(w, pos, side, newColor.dye);
    }

    public void cycleColors(ItemStack is, ItemStack paintBall, int i) {
        if (paintBall == null) {
            this.setColor(is, this.getColor(is));
        } else {
            this.setColor(is, this.findNextColor(is, paintBall, i));
        }
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventory cd;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
        }
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 27;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        if (requestedAddition != null) {
            int[] id;
            for (int x : id = OreDictionary.getOreIDs((ItemStack)requestedAddition.getItemStack())) {
                if (!ORE_TO_COLOR.containsKey(x)) continue;
                return false;
            }
            if (requestedAddition.getItem() instanceof ItemSnowball) {
                return false;
            }
            return !(requestedAddition.getItem() instanceof ItemPaintBall) || requestedAddition.getItemDamage() >= 20;
        }
        return true;
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }

    @Override
    public String getUnlocalizedGroupName(Set<ItemStack> others, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).func_74778_a("FuzzyMode", fzMode.name());
    }

    @Override
    public void onWheel(ItemStack is, boolean up) {
        this.cycleColors(is, this.getColor(is), up ? 1 : -1);
    }

    static {
        for (AEColor color : AEColor.VALID_COLORS) {
            String dyeName = color.dye.func_176762_d();
            String oreDictName = "dye" + WordUtils.capitalize((String)dyeName);
            int oreDictId = OreDictionary.getOreID((String)oreDictName);
            ORE_TO_COLOR.put(oreDictId, color);
        }
    }
}

