/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.CommonHelper;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.parts.PartPlacement;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class PacketPartPlacement
extends AppEngPacket {
    private int x;
    private int y;
    private int z;
    private int face;
    private float eyeHeight;
    private EnumHand hand;

    public PacketPartPlacement(ByteBuf stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.face = stream.readByte();
        this.eyeHeight = stream.readFloat();
        this.hand = EnumHand.values()[stream.readByte()];
    }

    public PacketPartPlacement(BlockPos pos, EnumFacing face, float eyeHeight, EnumHand hand) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeInt(pos.func_177958_n());
        data.writeInt(pos.func_177956_o());
        data.writeInt(pos.func_177952_p());
        data.writeByte(face.ordinal());
        data.writeFloat(eyeHeight);
        data.writeByte(hand.ordinal());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        EntityPlayerMP sender = (EntityPlayerMP)player;
        CommonHelper.proxy.updateRenderMode((EntityPlayer)sender);
        PartPlacement.setEyeHeight(this.eyeHeight);
        PartPlacement.place(sender.func_184586_b(this.hand), new BlockPos(this.x, this.y, this.z), EnumFacing.field_82609_l[this.face], (EntityPlayer)sender, this.hand, sender.field_70170_p, PartPlacement.PlaceType.INTERACT_FIRST_PASS, 0);
        CommonHelper.proxy.updateRenderMode(null);
    }
}

