/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.SkyCompassBakedModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class SkyCompassModel
implements IModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2:block/sky_compass_base");
    private static final ResourceLocation MODEL_POINTER = new ResourceLocation("appliedenergistics2:block/sky_compass_pointer");
    private static final List<ResourceLocation> DEPENDENCIES = ImmutableList.of((Object)MODEL_BASE, (Object)MODEL_POINTER);

    public Collection<ResourceLocation> getDependencies() {
        return DEPENDENCIES;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModel pointerModel;
        IModel baseModel;
        try {
            baseModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE);
            pointerModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_POINTER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IBakedModel bakedBase = baseModel.bake(state, format, bakedTextureGetter);
        IBakedModel bakedPointer = pointerModel.bake(state, format, bakedTextureGetter);
        return new SkyCompassBakedModel(bakedBase, bakedPointer);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

