/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

final class RenderHelper {
    private static EnumMap<EnumFacing, List<Vec3d>> cornersForFacing = RenderHelper.generateCornersForFacings();

    private RenderHelper() {
    }

    static List<Vec3d> getFaceCorners(EnumFacing side) {
        return cornersForFacing.get(side);
    }

    private static EnumMap<EnumFacing, List<Vec3d>> generateCornersForFacings() {
        EnumMap<EnumFacing, List<Vec3d>> result = new EnumMap<EnumFacing, List<Vec3d>>(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            List corners;
            float offset = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 0.0f : 1.0f;
            switch (facing.func_176740_k()) {
                default: {
                    corners = Lists.newArrayList((Object[])new Vec3d[]{new Vec3d((double)offset, 1.0, 1.0), new Vec3d((double)offset, 0.0, 1.0), new Vec3d((double)offset, 0.0, 0.0), new Vec3d((double)offset, 1.0, 0.0)});
                    break;
                }
                case Y: {
                    corners = Lists.newArrayList((Object[])new Vec3d[]{new Vec3d(1.0, (double)offset, 1.0), new Vec3d(1.0, (double)offset, 0.0), new Vec3d(0.0, (double)offset, 0.0), new Vec3d(0.0, (double)offset, 1.0)});
                    break;
                }
                case Z: {
                    corners = Lists.newArrayList((Object[])new Vec3d[]{new Vec3d(0.0, 1.0, (double)offset), new Vec3d(0.0, 0.0, (double)offset), new Vec3d(1.0, 0.0, (double)offset), new Vec3d(1.0, 1.0, (double)offset)});
                }
            }
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                corners = Lists.reverse((List)corners);
            }
            result.put(facing, (List<Vec3d>)ImmutableList.copyOf((Collection)corners));
        }
        return result;
    }

    private static Vec3d adjust(Vec3d vec, EnumFacing.Axis axis, double delta) {
        switch (axis) {
            default: {
                return new Vec3d(vec.field_72450_a + delta, vec.field_72448_b, vec.field_72449_c);
            }
            case Y: {
                return new Vec3d(vec.field_72450_a, vec.field_72448_b + delta, vec.field_72449_c);
            }
            case Z: 
        }
        return new Vec3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c + delta);
    }
}

