/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.BiometricCardBakedModel;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class BiometricCardModel
implements IModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "item/biometric_card");
    private static final ResourceLocation TEXTURE = new ResourceLocation("appliedenergistics2", "items/biometric_card_hash");

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(MODEL_BASE);
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.singletonList(TEXTURE);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite texture = (TextureAtlasSprite)bakedTextureGetter.apply((Object)TEXTURE);
        IBakedModel baseModel = this.getBaseModel(state, format, bakedTextureGetter);
        return new BiometricCardBakedModel(format, baseModel, texture);
    }

    private IBakedModel getBaseModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)MODEL_BASE).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

