/*
 * Decompiled with CFR 0.152.
 */
package com.mia.props;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.props.Props;
import com.mia.props.TabProps;
import com.mia.props.common.ColorsUtil;
import com.mia.props.common.TileTypeMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class DecoModelMetadata
extends ModelMetadata {
    public String name;
    public int decocraftModelID;
    public int lightLevel = 0;
    public int invX = 0;
    public int invY = 0;
    public boolean walkthrough = false;
    public boolean colorable = false;
    public boolean limitRotation = false;
    public boolean hasVariableRendering = false;
    public boolean spiderweb = false;
    public boolean hideDecobench = false;
    public TabProps tab = TabProps.Main;
    public TileTypeMap tileType = TileTypeMap.Props;
    public String sound;
    public String recipe;
    public String colorPrimary;
    public String colorSecondary;
    public String colorAccentPrimary;
    public String colorAccentSecondary;
    public Map<Integer, JsonObject> variants = null;
    public transient int[] resourceCost = new int[4];
    public transient float itemScale = -1.0f;
    public transient Vector3 itemOffset;
    private transient Map<Integer, AxisAlignedBB> aabbs = new HashMap<Integer, AxisAlignedBB>();
    private static final HashMap<String, Field> fieldMap = new HashMap();

    public DecoModelMetadata() {
        if (fieldMap.isEmpty()) {
            for (Field f : DecoModelMetadata.class.getFields()) {
                fieldMap.put(f.getName(), f);
            }
        }
    }

    public DecoModelMetadata(DecoModelMetadata existingMeta, int newID, JsonObject changes) {
        if (fieldMap.isEmpty()) {
            for (Field f : DecoModelMetadata.class.getFields()) {
                fieldMap.put(f.getName(), f);
            }
        }
        this.craftstudioAssetName = existingMeta.craftstudioAssetName;
        this.craftstudioAssetID = existingMeta.craftstudioAssetID;
        this.scale = existingMeta.scale;
        this.textureOverride = null;
        this.tileParams = new HashMap(existingMeta.tileParams);
        this.csmodel = existingMeta.csmodel;
        this.name = existingMeta.name;
        this.decocraftModelID = newID;
        this.lightLevel = existingMeta.lightLevel;
        this.invX = existingMeta.invX;
        this.invY = existingMeta.invY;
        this.walkthrough = existingMeta.walkthrough;
        this.colorable = existingMeta.colorable;
        this.limitRotation = existingMeta.limitRotation;
        this.hasVariableRendering = existingMeta.hasVariableRendering;
        this.spiderweb = existingMeta.spiderweb;
        this.tab = existingMeta.tab;
        this.tileType = existingMeta.tileType;
        this.sound = existingMeta.sound;
        this.recipe = null;
        this.variants = null;
        this.colorPrimary = existingMeta.colorPrimary;
        this.colorSecondary = existingMeta.colorSecondary;
        this.colorAccentPrimary = existingMeta.colorAccentPrimary;
        this.colorAccentSecondary = existingMeta.colorAccentSecondary;
        this.resourceCost = Arrays.copyOf(existingMeta.resourceCost, 4);
        this.itemScale = existingMeta.itemScale;
        Vector3 vector3 = this.itemOffset = existingMeta.itemOffset != null ? new Vector3(existingMeta.itemOffset) : null;
        if (changes != null) {
            Gson gson = new GsonBuilder().create();
            for (Map.Entry entry : changes.entrySet()) {
                Field foundField = fieldMap.get(((String)entry.getKey()).intern());
                if (foundField == null) continue;
                try {
                    foundField.set(this, gson.fromJson((JsonElement)entry.getValue(), foundField.getGenericType()));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    @Override
    public void wrapperCallback() {
        super.wrapperCallback();
        int[] extendBlock = this.wrapper.getExtendBlock(0);
        int width = 1 + extendBlock[3] - extendBlock[0];
        int depth = 1 + extendBlock[5] - extendBlock[2];
        int height = extendBlock[4] - extendBlock[1];
        if (height == 0) {
            ++height;
        }
        if (this.colorPrimary != null) {
            this.wrapper.colorPrimary = ColorsUtil.parseColor(this.colorPrimary);
        }
        if (this.colorSecondary != null) {
            this.wrapper.colorSecondary = ColorsUtil.parseColor(this.colorSecondary);
        }
        if (this.colorAccentPrimary != null) {
            this.wrapper.colorAccentPrimary = ColorsUtil.parseColor(this.colorAccentPrimary);
        }
        if (this.colorAccentSecondary != null) {
            this.wrapper.colorAccentSecondary = ColorsUtil.parseColor(this.colorAccentSecondary);
        }
        this.resourceCost[0] = 3 * width * depth * height;
        int[] pixels = this.csmodel.getTexture().getRGB(0, 0, this.csmodel.getTexture().getWidth(), this.csmodel.getTexture().getHeight(), null, 0, this.csmodel.getTexture().getWidth());
        long[] total = new long[4];
        for (int pixel : pixels) {
            if ((pixel >> 24 & 0xFF) == 0) continue;
            int r = pixel >> 16 & 0xFF;
            int g = pixel >> 8 & 0xFF;
            int b = pixel & 0xFF;
            total[0] = total[0] + (long)(r + g + b);
            total[1] = total[1] + (long)r;
            total[2] = total[2] + (long)g;
            total[3] = total[3] + (long)b;
        }
        float[] colorRatios = new float[3];
        for (int i = 1; i < 4; ++i) {
            colorRatios[i - 1] = (float)total[i] / (float)total[0];
        }
        if (this.wrapper.colorPrimary != null) {
            colorRatios[0] = colorRatios[0] * (1.0f + (float)this.wrapper.colorPrimary.getRed() / 255.0f);
            colorRatios[1] = colorRatios[1] * (1.0f + (float)this.wrapper.colorPrimary.getGreen() / 255.0f);
            colorRatios[2] = colorRatios[2] * (1.0f + (float)this.wrapper.colorPrimary.getBlue() / 255.0f);
            float divisor = colorRatios[0] + colorRatios[1] + colorRatios[2];
            colorRatios[0] = colorRatios[0] / divisor;
            colorRatios[1] = colorRatios[1] / divisor;
            colorRatios[2] = colorRatios[2] / divisor;
        }
        for (int i = 1; i < 4; ++i) {
            this.resourceCost[i] = Math.round((float)this.resourceCost[0] * colorRatios[i - 1]);
        }
        Vector3[] extend = this.wrapper.getExtend(8);
        this.itemScale = Math.min(1.0f / Math.abs(extend[1].y - extend[0].y), Math.min(1.0f / Math.abs(extend[1].x - extend[0].x), 1.0f / Math.abs(extend[1].z - extend[0].z)));
        this.itemOffset = new Vector3(-((extend[0].x + extend[1].x) / 2.0f), -((extend[0].y + extend[1].y) / 35.0f + (extend[0].y < 0.0f ? extend[0].y / 2.0f : 0.0f) + (extend[0].y > 0.0f ? extend[0].y : 0.0f) + (extend[1].y > 0.5f ? extend[1].y / 35.0f : 0.0f) + 0.84f), -((extend[0].z + extend[1].z) / 2.2f));
    }

    public void validate() {
        if (Props.enabledOldStyleRecipes) {
            if (this.recipe == null) {
                String[] symbols = new String[]{"_", "R", "G", "B"};
                this.recipe = "";
                for (int i = 0; i < 9; ++i) {
                    this.recipe = this.recipe + symbols[(this.decocraftModelID + 1) / (i + 1) % 4];
                }
            }
            if (Props.recipes.contains(this.recipe)) {
                throw new RuntimeException(String.format("Recipe %s is already registered !", this.recipe));
            }
            Props.recipes.add(this.recipe);
            if (this.recipe.length() != 9) {
                throw new RuntimeException(String.format("Recipe %s is not 9 chars long !", new Object[0]));
            }
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Props.itemProps, 1, this.decocraftModelID), new Object[]{this.recipe.substring(0, 3).replace("_", " ").toUpperCase(), this.recipe.substring(3, 6).replace("_", " ").toUpperCase(), this.recipe.substring(6, 9).replace("_", " ").toUpperCase(), Character.valueOf('R'), new ItemStack(Props.itemClay, 1, 0), Character.valueOf('B'), new ItemStack(Props.itemClay, 1, 1), Character.valueOf('G'), new ItemStack(Props.itemClay, 1, 2)}).setMirrored(false));
        }
        if (this.textureOverride == null) {
            this.textureOverride = this.getDefaultTextureName();
        }
        if (this.csmodel.getRootNode() != null && this.csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) {
            this.walkthrough = true;
        }
    }

    public String getDefaultTextureName() {
        return String.format("%04d_%s.png", this.decocraftModelID, this.name.toLowerCase().replaceAll("[/\\\\:*?\"<>|' ]", "_"));
    }

    public boolean isCraftable(int[] availableResources) {
        return availableResources[0] >= this.resourceCost[0] && availableResources[1] >= this.resourceCost[1] && availableResources[2] >= this.resourceCost[2] && availableResources[3] >= this.resourceCost[3];
    }

    @Override
    public int compareTo(ModelMetadata o) {
        if (o instanceof DecoModelMetadata) {
            if (this.decocraftModelID < ((DecoModelMetadata)o).decocraftModelID) {
                return -1;
            }
            if (this.decocraftModelID > ((DecoModelMetadata)o).decocraftModelID) {
                return 1;
            }
            return 0;
        }
        return super.compareTo(o);
    }

    public AxisAlignedBB getBoundingBox(int rotation) {
        AxisAlignedBB aabb = this.aabbs.get(rotation);
        if (aabb == null) {
            Vector3[] extend = this.wrapper.getExtend(rotation);
            aabb = new AxisAlignedBB((double)extend[0].x, (double)extend[0].y, (double)extend[0].z, (double)extend[1].x, (double)extend[1].y, (double)extend[1].z);
            this.aabbs.put(rotation, aabb);
            return aabb;
        }
        return aabb;
    }
}

