/*
 * Decompiled with CFR 0.152.
 */
package codechicken.obfuscator;

import codechicken.lib.asm.ObfMapping;
import codechicken.obfuscator.IHeirachyEvaluator;
import codechicken.obfuscator.ILogStreams;
import codechicken.obfuscator.ObfuscationRun;
import codechicken.obfuscator.SystemLogStreams;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ObfuscationMap {
    private Map<String, ClassEntry> srgMap = new HashMap<String, ClassEntry>();
    private Map<String, ClassEntry> obfMap = new HashMap<String, ClassEntry>();
    private ArrayListMultimap<String, ObfuscationEntry> srgMemberMap = ArrayListMultimap.create();
    private IHeirachyEvaluator heirachyEvaluator;
    private HashSet<String> mappedClasses = new HashSet();
    public ILogStreams log = SystemLogStreams.inst;

    public ObfuscationMap setHeirachyEvaluator(IHeirachyEvaluator eval) {
        this.heirachyEvaluator = eval;
        return this;
    }

    public ObfuscationMap setLog(ILogStreams log) {
        this.log = log;
        return this;
    }

    public ObfuscationEntry addClass(String obf, String srg) {
        return this.addEntry(new ObfMapping(obf, "", ""), new ObfMapping(srg, "", ""));
    }

    public ObfuscationEntry addField(String obf_owner, String obf_name, String srg_owner, String srg_name) {
        return this.addEntry(new ObfMapping(obf_owner, obf_name, ""), new ObfMapping(srg_owner, srg_name, ""));
    }

    public ObfuscationEntry addMethod(String obf_owner, String obf_name, String obf_desc, String srg_owner, String srg_name, String srg_desc) {
        return this.addEntry(new ObfMapping(obf_owner, obf_name, obf_desc), new ObfMapping(srg_owner, srg_name, srg_desc));
    }

    public ObfuscationEntry addEntry(ObfMapping obf_desc, ObfMapping srg_desc) {
        ClassEntry e = this.srgMap.get(srg_desc.s_owner);
        if (e == null) {
            e = new ClassEntry(obf_desc.s_owner, srg_desc.s_owner);
            this.obfMap.put(obf_desc.s_owner, e);
            this.srgMap.put(srg_desc.s_owner, e);
        }
        if (obf_desc.s_name.length() > 0) {
            return e.addEntry(obf_desc, srg_desc);
        }
        return e;
    }

    public void addMcpName(String srg_name, String mcp_name) {
        List entries = this.srgMemberMap.get((Object)srg_name);
        if (entries.isEmpty()) {
            this.log.err().println("Tried to add mcp name (" + mcp_name + ") for unknown srg key (" + srg_name + ")");
            return;
        }
        for (ObfuscationEntry entry : entries) {
            entry.mcp.s_name = mcp_name;
            this.srgMap.get((Object)entry.srg.s_owner).mcpMap.put(entry.mcp.s_name.concat(entry.mcp.s_desc), entry);
        }
    }

    public ObfuscationEntry lookupSrg(String srg_key) {
        List list = this.srgMemberMap.get((Object)srg_key);
        return list.isEmpty() ? null : (ObfuscationEntry)list.get(0);
    }

    public ObfuscationEntry lookupMcpClass(String name) {
        return this.srgMap.get(name);
    }

    public ObfuscationEntry lookupObfClass(String name) {
        return this.obfMap.get(name);
    }

    public ObfuscationEntry lookupMcpField(String owner, String name) {
        return this.lookupMcpMethod(owner, name, "");
    }

    public ObfuscationEntry lookupSrgField(String owner, String name) {
        ObfuscationEntry e;
        if (name.startsWith("field_") && (e = this.lookupSrg(name)) != null) {
            return e;
        }
        this.evaluateHeirachy(owner);
        e = this.srgMap.get(owner);
        return e == null ? null : ((ClassEntry)e).srgMap.get(name);
    }

    public ObfuscationEntry lookupObfField(String owner, String name) {
        return this.lookupObfMethod(owner, name, "");
    }

    public ObfuscationEntry lookupMcpMethod(String owner, String name, String desc) {
        this.evaluateHeirachy(owner);
        ClassEntry e = this.srgMap.get(owner);
        return e == null ? null : e.mcpMap.get(name.concat(desc));
    }

    public ObfuscationEntry lookupObfMethod(String owner, String name, String desc) {
        this.evaluateHeirachy(owner);
        ClassEntry e = this.obfMap.get(owner);
        return e == null ? null : e.obfMap.get(name.concat(desc));
    }

    private boolean isMapped(ObfuscationEntry desc) {
        return this.mappedClasses.contains(desc.srg.s_owner);
    }

    private ObfuscationEntry getOrCreateClassEntry(String name) {
        ObfuscationEntry e = this.lookupObfClass(name);
        if (e == null) {
            e = this.lookupMcpClass(name);
        }
        if (e == null) {
            e = this.addClass(name, name);
        }
        return e;
    }

    public ObfuscationEntry evaluateHeirachy(String name) {
        ObfuscationEntry desc = this.getOrCreateClassEntry(name);
        if (this.isMapped(desc)) {
            return desc;
        }
        this.mappedClasses.add(desc.srg.s_owner);
        if (this.heirachyEvaluator == null) {
            throw new IllegalArgumentException("Cannot call method/field mappings if a heirachy evaluator is not set.");
        }
        if (!this.heirachyEvaluator.isLibClass(desc)) {
            List<String> parents = this.heirachyEvaluator.getParents(desc);
            if (parents == null) {
                this.log.err().println("Could not find class: " + desc.srg.s_owner);
            } else {
                for (String parent : parents) {
                    this.inherit(desc, this.evaluateHeirachy(parent));
                }
            }
        }
        return desc;
    }

    public void inherit(ObfuscationEntry desc, ObfuscationEntry p_desc) {
        this.inherit(desc.srg.s_owner, p_desc.srg.s_owner);
    }

    public void inherit(String name, String parent) {
        ClassEntry e = this.srgMap.get(name);
        if (e == null) {
            throw new IllegalStateException("Tried to inerit to an undefined class: " + name + " extends " + parent);
        }
        ClassEntry p = this.srgMap.get(parent);
        if (p == null) {
            throw new IllegalStateException("Tried to inerit from undefired parent: " + name + " extends " + parent);
        }
        e.inheritFrom(p);
    }

    public void parseMappings(File[] mappings) {
        this.parseSRGS(mappings[0]);
        this.parseCSV(mappings[1]);
        this.parseCSV(mappings[2]);
    }

    public static String[] splitLast(String s, char c) {
        int i = s.lastIndexOf(c);
        return new String[]{s.substring(0, i), s.substring(i + 1)};
    }

    public static String[] split4(String s, char c) {
        String[] split = new String[4];
        int i2 = s.indexOf(c);
        split[0] = s.substring(0, i2);
        int i = i2 + 1;
        i2 = s.indexOf(c, i);
        split[1] = s.substring(i, i2);
        i = i2 + 1;
        i2 = s.indexOf(c, i);
        split[2] = s.substring(i, i2);
        i = i2 + 1;
        i2 = s.indexOf(c, i);
        split[3] = s.substring(i);
        return split;
    }

    private void parseSRGS(File srgs) {
        this.log.out().println("Parsing " + srgs.getName());
        Function<String, Void> function = new Function<String, Void>(){

            public Void apply(String line) {
                int hpos = line.indexOf(35);
                if (hpos > 0) {
                    line = line.substring(0, hpos).trim();
                }
                if (line.startsWith("CL: ")) {
                    String[] params = ObfuscationMap.splitLast(line.substring(4), ' ');
                    ObfuscationMap.this.addClass(params[0], params[1]);
                } else {
                    if (line.startsWith("FD: ")) {
                        String[] params = ObfuscationMap.splitLast(line.substring(4), ' ');
                        String[] p1 = ObfuscationMap.splitLast(params[0], '/');
                        String[] p2 = ObfuscationMap.splitLast(params[1], '/');
                        ObfuscationMap.this.addField(p1[0], p1[1], p2[0], p2[1]);
                        return null;
                    }
                    if (line.startsWith("MD: ")) {
                        String[] params = ObfuscationMap.split4(line.substring(4), ' ');
                        String[] p1 = ObfuscationMap.splitLast(params[0], '/');
                        String[] p2 = ObfuscationMap.splitLast(params[2], '/');
                        ObfuscationMap.this.addMethod(p1[0], p1[1], params[1], p2[0], p2[1], params[3]);
                        return null;
                    }
                }
                return null;
            }
        };
        ObfuscationRun.processLines(srgs, function);
    }

    private void parseCSV(File csv) {
        this.log.out().println("Parsing " + csv.getName());
        Function<String, Void> function = new Function<String, Void>(){

            public Void apply(String line) {
                if (line.startsWith("func_") || line.startsWith("field_")) {
                    int i = line.indexOf(44);
                    String srg = line.substring(0, i);
                    int i2 = i + 1;
                    i = line.indexOf(44, i2);
                    String mcp = line.substring(i2, i);
                    ObfuscationMap.this.addMcpName(srg, mcp);
                }
                return null;
            }
        };
        ObfuscationRun.processLines(csv, function);
    }

    private class ClassEntry
    extends ObfuscationEntry {
        public Map<String, ObfuscationEntry> mcpMap;
        public Map<String, ObfuscationEntry> srgMap;
        public Map<String, ObfuscationEntry> obfMap;

        public ClassEntry(String obf, String srg) {
            super(new ObfMapping(obf, "", ""), new ObfMapping(srg, "", ""), new ObfMapping(srg, "", ""));
            this.mcpMap = new HashMap<String, ObfuscationEntry>();
            this.srgMap = new HashMap<String, ObfuscationEntry>();
            this.obfMap = new HashMap<String, ObfuscationEntry>();
        }

        public ObfuscationEntry addEntry(ObfMapping obf_desc, ObfMapping srg_desc) {
            ObfuscationEntry entry = new ObfuscationEntry(obf_desc, srg_desc, srg_desc.copy());
            this.obfMap.put(obf_desc.s_name.concat(obf_desc.s_desc), entry);
            this.srgMap.put(srg_desc.s_name, entry);
            if (srg_desc.s_name.startsWith("field_") || srg_desc.s_name.startsWith("func_")) {
                ObfuscationMap.this.srgMemberMap.put((Object)srg_desc.s_name, (Object)entry);
            }
            return entry;
        }

        public void inheritFrom(ClassEntry p) {
            this.inherit(this.obfMap, p.obfMap);
            this.inherit(this.srgMap, p.srgMap);
            this.inherit(this.mcpMap, p.mcpMap);
        }

        private void inherit(Map<String, ObfuscationEntry> child, Map<String, ObfuscationEntry> parent) {
            for (Map.Entry<String, ObfuscationEntry> e : parent.entrySet()) {
                if (child.containsKey(e.getKey())) continue;
                child.put(e.getKey(), e.getValue());
            }
        }
    }

    public class ObfuscationEntry {
        public final ObfMapping obf;
        public final ObfMapping srg;
        public final ObfMapping mcp;

        public ObfuscationEntry(ObfMapping obf, ObfMapping srg, ObfMapping mcp) {
            this.obf = obf;
            this.srg = srg;
            this.mcp = mcp;
        }
    }
}

