/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.network.PacketReturnGeneratorInfo;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetGeneratorInfo
implements IMessage {
    private int networkId;

    public void fromBytes(ByteBuf buf) {
        this.networkId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkId);
    }

    public PacketGetGeneratorInfo() {
    }

    public PacketGetGeneratorInfo(int networkId) {
        this.networkId = networkId;
    }

    public static class Handler
    implements IMessageHandler<PacketGetGeneratorInfo, IMessage> {
        public IMessage onMessage(PacketGetGeneratorInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetGeneratorInfo message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            DRGeneratorNetwork generatorNetwork = DRGeneratorNetwork.getChannels(world);
            DRGeneratorNetwork.Network network = generatorNetwork.getChannel(message.networkId);
            if (network == null) {
                return;
            }
            PacketReturnGeneratorInfo packet = new PacketReturnGeneratorInfo(message.networkId, network.getEnergy(), network.getGeneratorBlocks(), network.getLastRfPerTick());
            DeepResonance.networkHandler.sendTo((IMessage)packet, ctx.getServerHandler().field_147369_b);
        }
    }
}

