/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.tank;

import com.google.common.collect.Maps;
import elec332.core.main.ElecCore;
import elec332.core.network.IElecCoreNetworkTile;
import elec332.core.world.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.deepresonance.blocks.tank.ITankHook;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.tanks.TankGrid;
import mcjty.deepresonance.varia.FluidTankWrapper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.tools.WorldTools;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTank
extends GenericTileEntity
implements IElecCoreNetworkTile {
    private Fluid clientRenderFluid;
    private float renderHeight;
    private final IFluidHandler input;
    private final IFluidHandler output;
    private final IFluidHandler inputOutput;
    private NBTTagCompound multiBlockSaveData;
    protected Map<EnumFacing, Mode> settings = Maps.newHashMap();
    private Map<EnumFacing, ITankHook> tankHooks;
    private boolean hooksInit = false;
    private static Map<ChunkPos, Map<BlockPos, EnumFacing>> toLoad = Maps.newHashMap();
    private TankGrid multiBlock;
    public FluidStack myTank;
    public Fluid lastSeenFluid;
    public static final int ID_GENERIC = 1;
    public static final int ID_SETFLUID = 2;
    public static final int ID_SETHEIGHT = 3;

    public TileTank() {
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            this.settings.put(direction, Mode.SETTING_NONE);
        }
        this.multiBlockSaveData = new NBTTagCompound();
        this.tankHooks = Maps.newHashMap();
        this.input = new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return TileTank.this.multiBlock;
            }

            @Override
            protected boolean canDrain() {
                return false;
            }
        };
        this.output = new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return TileTank.this.multiBlock;
            }

            @Override
            protected boolean canFill() {
                return false;
            }
        };
        this.inputOutput = new FluidTankWrapper(){

            @Override
            protected IFluidTank getTank() {
                return TileTank.this.multiBlock;
            }
        };
    }

    public void onPacketReceivedFromClient(EntityPlayerMP sender, int ID, NBTTagCompound data) {
    }

    private List<EntityPlayerMP> getAllPlayersWatchingBlock(World world, int x, int z) {
        ArrayList<EntityPlayerMP> ret = new ArrayList<EntityPlayerMP>();
        if (world instanceof WorldServer) {
            PlayerChunkMap playerManager = ((WorldServer)world).func_184164_w();
            for (EntityPlayerMP player : WorldTools.getPlayerList((WorldServer)((WorldServer)this.func_145831_w()))) {
                Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
                if (!playerManager.func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
                ret.add(player);
            }
        }
        return ret;
    }

    public void sendPacket(int ID, NBTTagCompound data) {
        for (EntityPlayerMP player : this.getAllPlayersWatchingBlock(this.func_145831_w(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())) {
            player.field_71135_a.func_147359_a((Packet)new SPacketUpdateTileEntity(this.field_174879_c, ID, data));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        ElecCore.tickHandler.registerCall(() -> {
            if (WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)this.field_174879_c)) {
                this.onTileLoaded();
            }
        }, this.func_145831_w());
    }

    public void func_145843_s() {
        if (!this.func_145837_r()) {
            super.func_145843_s();
            this.onTileUnloaded();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.onTileUnloaded();
    }

    public void onTileLoaded() {
        if (!this.func_145831_w().field_72995_K) {
            this.initHooks();
        }
    }

    public void onTileUnloaded() {
        if (!this.func_145831_w().field_72995_K) {
            for (EnumFacing f : EnumFacing.field_82609_l) {
                Optional.ofNullable(toLoad.get(this.getChunk(this.field_174879_c.func_177972_a(f)))).ifPresent(map -> {
                    EnumFacing cfr_ignored_0 = (EnumFacing)map.remove(this.field_174879_c);
                });
            }
            for (Map.Entry entry : this.getConnectedHooks().entrySet()) {
                ((ITankHook)entry.getValue()).unHook(this, ((EnumFacing)entry.getKey()).func_176734_d());
            }
            this.getConnectedHooks().clear();
            this.hooksInit = false;
        }
    }

    public void onNeighborChange() {
        Map<EnumFacing, ITankHook> hookMap = this.getConnectedHooks();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ITankHook tankHook = hookMap.get(facing);
            BlockPos pos = this.func_174877_v().func_177972_a(facing);
            TileEntity tile = WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)pos) ? WorldHelper.getTileAt((IBlockAccess)this.func_145831_w(), (BlockPos)pos) : null;
            if (tile == null != (tankHook == null) || tile != tankHook) {
                hookMap.remove(facing);
                if (tile != null) {
                    Optional.ofNullable(toLoad.get(this.getChunk(pos))).ifPresent(set -> {
                        EnumFacing cfr_ignored_0 = (EnumFacing)set.remove(this.func_174877_v());
                    });
                }
                if (!(tile instanceof ITankHook)) continue;
                ((ITankHook)tile).hook(this, facing.func_176734_d());
                hookMap.put(facing, (ITankHook)tile);
                continue;
            }
            if (tankHook == null) continue;
            tankHook.onContentChanged(this, facing.func_176734_d());
        }
    }

    private void initHooks() {
        this.tankHooks.clear();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos offPos = this.func_174877_v().func_177972_a(facing);
            if (!WorldHelper.chunkLoaded((World)this.func_145831_w(), (BlockPos)offPos)) {
                ChunkPos chP = this.getChunk(offPos);
                HashMap dta = toLoad.get(chP);
                if (dta == null) {
                    dta = Maps.newHashMap();
                    toLoad.put(chP, dta);
                }
                dta.put((BlockPos)offPos, (EnumFacing)facing);
                continue;
            }
            this.initLoaded(facing);
        }
        this.hooksInit = true;
    }

    private void initLoaded(EnumFacing facing) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177972_a(facing));
        if (tile instanceof ITankHook) {
            this.tankHooks.put(facing, (ITankHook)tile);
            ((ITankHook)tile).hook(this, facing.func_176734_d());
        }
    }

    public Map<EnumFacing, Mode> getSettings() {
        return this.settings;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("settings", 10);
        if (tagList != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                EnumFacing side = EnumFacing.values()[tag.func_74762_e("dir")];
                Mode mode = Mode.values()[tag.func_74762_e("n")];
                this.settings.put(side, mode);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<EnumFacing, Mode> entry : this.settings.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("dir", entry.getKey().ordinal());
            tag.func_74768_a("n", entry.getValue().ordinal());
            tagList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("settings", (NBTBase)tagList);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.myTank = TileTank.getFluidStackFromNBT(tagCompound);
        this.multiBlockSaveData = tagCompound.func_74775_l("multiBlockData");
        if (tagCompound.func_74764_b("lastSeenFluid")) {
            this.lastSeenFluid = FluidRegistry.getFluid((String)tagCompound.func_74779_i("lastSeenFluid"));
        } else if (this.multiBlockSaveData.func_74764_b("lastSeenFluid")) {
            this.lastSeenFluid = FluidRegistry.getFluid((String)this.multiBlockSaveData.func_74779_i("lastSeenFluid"));
        }
    }

    public static FluidStack getFluidStackFromNBT(NBTTagCompound tagCompound) {
        NBTTagCompound mbTag = tagCompound.func_74775_l("multiBlockData");
        Object s = tagCompound.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("fluid")) : (mbTag.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)mbTag.func_74775_l("fluid")) : null);
        return s;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.multiBlock != null) {
            this.multiBlock.setDataToTile(this);
        }
        tagCompound.func_74782_a("multiBlockData", (NBTBase)this.multiBlockSaveData);
    }

    public void setTank(TankGrid multiBlock) {
        this.multiBlock = multiBlock;
    }

    public TankGrid getTank() {
        return this.multiBlock;
    }

    public void setSaveData(NBTTagCompound nbtTagCompound) {
        this.multiBlockSaveData = nbtTagCompound;
        this.myTank = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTagCompound.func_74775_l("fluid"));
        this.lastSeenFluid = FluidRegistry.getFluid((String)nbtTagCompound.func_74779_i("lastSeenFluid"));
    }

    public Fluid getClientRenderFluid() {
        return this.clientRenderFluid;
    }

    @SideOnly(value=Side.CLIENT)
    public float getRenderHeight() {
        return this.renderHeight;
    }

    public FluidStack getFluid() {
        return this.multiBlock == null ? null : this.multiBlock.getFluid();
    }

    public NBTTagCompound getFluidTag() {
        return this.getFluid() == null ? null : this.getFluid().tag;
    }

    public int getFluidAmount() {
        return this.multiBlock == null ? 0 : this.multiBlock.getFluidAmount();
    }

    public int getCapacity() {
        return this.multiBlock == null ? 0 : this.multiBlock.getCapacity();
    }

    private void notifyChanges(boolean b) {
        if (this.multiBlock != null && b) {
            for (Map.Entry<EnumFacing, ITankHook> entry : this.getConnectedHooks().entrySet()) {
                entry.getValue().onContentChanged(this, entry.getKey().func_176734_d());
            }
        }
    }

    private Map<EnumFacing, ITankHook> getConnectedHooks() {
        return this.tankHooks;
    }

    public boolean isInput(EnumFacing direction) {
        return direction == null || this.settings.get(direction) == Mode.SETTING_ACCEPT;
    }

    public boolean isOutput(EnumFacing direction) {
        return direction == null || this.settings.get(direction) == Mode.SETTING_PROVIDE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (this.isInput(facing) || this.isOutput(facing)) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.inputOutput;
            }
            if (this.isOutput(facing)) {
                return (T)this.output;
            }
            if (this.isInput(facing)) {
                return (T)this.input;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return super.func_189517_E_();
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        super.readClientDataFromNBT(tagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        if (packet.func_148853_f() == 1) {
            super.onDataPacket(net, packet);
        } else {
            this.onDataPacket(packet.func_148853_f(), packet.func_148857_g());
        }
    }

    public void onDataPacket(int id, NBTTagCompound tag) {
        switch (id) {
            case 2: {
                this.clientRenderFluid = FluidRegistry.getFluid((String)tag.func_74779_i("fluid"));
                return;
            }
            case 3: {
                this.renderHeight = tag.func_74760_g("render");
            }
        }
    }

    private ChunkPos getChunk() {
        return this.getChunk(this.func_174877_v());
    }

    private ChunkPos getChunk(BlockPos pos) {
        return new ChunkPos(pos);
    }

    static {
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onChunkLoad(ChunkEvent.Load event) {
                Map dta = (Map)toLoad.remove(event.getChunk().func_76632_l());
                if (dta != null && ConfigMachines.experimentalChunkBorderFix) {
                    World world = event.getWorld();
                    for (Map.Entry e : dta.entrySet()) {
                        TileEntity tile;
                        if (!WorldHelper.chunkLoaded((World)world, (BlockPos)((BlockPos)e.getKey())) || !((tile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)((BlockPos)e.getKey()))) instanceof TileTank)) continue;
                        ((TileTank)tile).initLoaded((EnumFacing)e.getValue());
                    }
                }
            }
        });
    }

    public static enum Mode implements IStringSerializable
    {
        SETTING_NONE("none"),
        SETTING_ACCEPT("accept"),
        SETTING_PROVIDE("provide");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

