/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.tank;

import elec332.core.api.client.IIconRegistrar;
import elec332.core.api.client.ITextureLoader;
import elec332.core.util.PlayerHelper;
import elec332.core.world.WorldHelper;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.GenericDRBlock;
import mcjty.deepresonance.blocks.tank.TankTESR;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.client.ClientHandler;
import mcjty.deepresonance.client.DRResourceLocation;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.deepresonance.network.PacketGetTankInfo;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.tools.FluidTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.tools.WorldTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class BlockTank
extends GenericDRBlock<TileTank, EmptyContainer>
implements ITextureLoader {
    public static final PropertyEnum<TileTank.Mode> NORTH = PropertyEnum.func_177709_a((String)"north", TileTank.Mode.class);
    public static final PropertyEnum<TileTank.Mode> SOUTH = PropertyEnum.func_177709_a((String)"south", TileTank.Mode.class);
    public static final PropertyEnum<TileTank.Mode> WEST = PropertyEnum.func_177709_a((String)"west", TileTank.Mode.class);
    public static final PropertyEnum<TileTank.Mode> EAST = PropertyEnum.func_177709_a((String)"east", TileTank.Mode.class);
    public static final PropertyEnum<TileTank.Mode> UP = PropertyEnum.func_177709_a((String)"up", TileTank.Mode.class);
    public static final PropertyEnum<TileTank.Mode> DOWN = PropertyEnum.func_177709_a((String)"down", TileTank.Mode.class);
    public static final PropertyInteger DUMMY_RCL = PropertyInteger.func_177719_a((String)"dummy_rcl", (int)0, (int)1);
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite iconSide;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite iconTop;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite iconBottom;
    private long lastTime;
    public int totalFluidAmount = 0;
    public int tankCapacity = 0;
    public LiquidCrystalFluidTagData fluidData = null;
    public Fluid clientRenderFluid = null;

    public BlockTank() {
        super(Material.field_151576_e, TileTank.class, EmptyContainer.class, "tank", true);
    }

    public boolean hasNoRotation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        super.initModel();
        ClientRegistry.bindTileEntitySpecialRenderer(TileTank.class, (TileEntitySpecialRenderer)new TankTESR());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean advancedToolTip) {
        FluidStack fluidStack;
        super.func_190948_a(itemStack, player, list, advancedToolTip);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (fluidStack = TileTank.getFluidStackFromNBT(tagCompound)) != null) {
            list.add(TextFormatting.GREEN + "Fluid: " + DRFluidRegistry.getFluidName(fluidStack));
            list.add(TextFormatting.GREEN + "Amount: " + DRFluidRegistry.getAmount(fluidStack) + " mb");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This tank can hold up to 16 buckets of liquid.");
            list.add("It is also capable of mixing the characteristics");
            list.add("of liquid crystal.");
            list.add("Place a comparator next to this tank to detect");
            list.add("how filled the tank is");
        } else {
            list.add(TextFormatting.WHITE + ClientHandler.getShiftMessage());
        }
    }

    public int getGuiID() {
        return -1;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof TileTank) {
            TileTank tank = (TileTank)te;
            Map<EnumFacing, TileTank.Mode> settings = tank.getSettings();
            TileTank.Mode i = settings.get(data.getSideHit());
            probeInfo.text(TextFormatting.GREEN + "Mode: " + (i == TileTank.Mode.SETTING_NONE ? "none" : (i == TileTank.Mode.SETTING_ACCEPT ? "accept" : "provide")));
            LiquidCrystalFluidTagData lcd = LiquidCrystalFluidTagData.fromStack(tank.getFluid());
            if (lcd != null) {
                DecimalFormat decimalFormat = new DecimalFormat("#.#");
                probeInfo.text(TextFormatting.YELLOW + "Quality: " + decimalFormat.format(lcd.getQuality() * 100.0f) + "%");
                probeInfo.text(TextFormatting.YELLOW + "Purity: " + decimalFormat.format(lcd.getPurity() * 100.0f) + "%");
                probeInfo.text(TextFormatting.YELLOW + "Strength: " + decimalFormat.format(lcd.getStrength() * 100.0f) + "%");
                probeInfo.text(TextFormatting.YELLOW + "Efficiency: " + decimalFormat.format(lcd.getEfficiency() * 100.0f) + "%");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileTank tankTile = (TileTank)accessor.getTileEntity();
        Map<EnumFacing, TileTank.Mode> settings = tankTile.getSettings();
        TileTank.Mode i = settings.get(accessor.getSide());
        currentTip.add("Mode: " + (i == TileTank.Mode.SETTING_NONE ? "none" : (i == TileTank.Mode.SETTING_ACCEPT ? "accept" : "provide")));
        currentTip.add("Fluid: " + DRFluidRegistry.getFluidName(this.clientRenderFluid));
        currentTip.add("Amount: " + this.totalFluidAmount + " (" + this.tankCapacity + ")");
        if (this.fluidData != null) {
            DecimalFormat decimalFormat = new DecimalFormat("#.#");
            currentTip.add(TextFormatting.YELLOW + "Quality: " + decimalFormat.format(this.fluidData.getQuality() * 100.0f) + "%");
            currentTip.add(TextFormatting.YELLOW + "Purity: " + decimalFormat.format(this.fluidData.getPurity() * 100.0f) + "%");
            currentTip.add(TextFormatting.YELLOW + "Strength: " + decimalFormat.format(this.fluidData.getStrength() * 100.0f) + "%");
            currentTip.add(TextFormatting.YELLOW + "Efficiency: " + decimalFormat.format(this.fluidData.getEfficiency() * 100.0f) + "%");
        }
        if (System.currentTimeMillis() - this.lastTime > 100L) {
            this.lastTime = System.currentTimeMillis();
            DeepResonance.networkHandler.sendToServer((IMessage)new PacketGetTankInfo(tankTile.func_174877_v()));
        }
        return currentTip;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileTank tank;
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (tile instanceof TileTank && (tank = (TileTank)tile).getTank() != null) {
            return tank.getTank().getComparatorInputOverride();
        }
        return 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (tile instanceof TileTank) {
            ((TileTank)tile).onNeighborChange();
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tile;
        super.func_176208_a(worldIn, pos, state, player);
        if (PlayerHelper.isPlayerInCreative((EntityPlayer)player) && (tile = WorldHelper.getTileAt((IBlockAccess)worldIn, (BlockPos)pos)) instanceof TileTank) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((TileTank)tile).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            WorldHelper.dropStack((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
    }

    protected boolean clOnBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (tile instanceof TileTank) {
            TileTank tank = (TileTank)tile;
            ItemStack mainItem = player.func_184586_b(EnumHand.MAIN_HAND);
            if (ItemStackTools.isValid((ItemStack)mainItem)) {
                if (FluidTools.isEmptyContainer((ItemStack)mainItem)) {
                    if (((TileTank)tile).getTank() != null && !world.field_72995_K) {
                        this.extractIntoContainer(player, tank.getTank());
                    }
                    return true;
                }
                if (FluidTools.isFilledContainer((ItemStack)mainItem)) {
                    if (((TileTank)tile).getTank() != null && !world.field_72995_K) {
                        this.fillFromContainer(player, tank.getTank());
                    }
                    return true;
                }
            }
            TileTank.Mode i = tank.settings.get(side);
            switch (i) {
                case SETTING_NONE: {
                    i = TileTank.Mode.SETTING_ACCEPT;
                    break;
                }
                case SETTING_ACCEPT: {
                    i = TileTank.Mode.SETTING_PROVIDE;
                    break;
                }
                case SETTING_PROVIDE: {
                    i = TileTank.Mode.SETTING_NONE;
                }
            }
            tank.settings.put(side, i);
            tank.func_70296_d();
            WorldHelper.markBlockForUpdate((World)world, (BlockPos)pos);
            WorldTools.notifyNeighborsOfStateChange((World)world, (BlockPos)pos, (Block)this);
            WorldHelper.markBlockForRenderUpdate((World)world, (BlockPos)pos);
            return true;
        }
        return super.clOnBlockActivated(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    private void fillFromContainer(EntityPlayer player, IFluidHandler tank) {
        int fill;
        FluidStack fluidStack = FluidTools.convertBucketToFluid((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND));
        if (fluidStack != null && (fill = tank.fill(fluidStack, false)) == fluidStack.amount) {
            tank.fill(fluidStack, true);
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack emptyContainer = FluidTools.drainContainer((ItemStack)player.func_184586_b(EnumHand.MAIN_HAND));
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
            }
        }
    }

    private void extractIntoContainer(EntityPlayer player, IFluidHandler tank) {
        FluidStack fluidStack = tank.drain(1, false);
        if (fluidStack != null) {
            ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND).func_77946_l();
            ItemStackTools.setStackSize((ItemStack)heldItem, (int)1);
            int capacity = FluidTools.getCapacity((FluidStack)fluidStack, (ItemStack)heldItem);
            if (capacity != 0 && (fluidStack = tank.drain(capacity, false)) != null && fluidStack.amount == capacity) {
                fluidStack = tank.drain(capacity, true);
                ItemStack filledContainer = FluidTools.fillContainer((FluidStack)fluidStack, (ItemStack)heldItem);
                if (ItemStackTools.isValid((ItemStack)filledContainer)) {
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    if (!player.field_71071_by.func_70441_a(filledContainer)) {
                        EntityItem entityItem = new EntityItem(player.func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, filledContainer);
                        WorldTools.spawnEntity((World)player.func_130014_f_(), (Entity)entityItem);
                    }
                    player.field_71070_bA.func_75142_b();
                } else {
                    tank.fill(fluidStack, true);
                }
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileTank tank;
        TileEntity tile = WorldHelper.getTileAt((IBlockAccess)world, (BlockPos)pos);
        if (tile instanceof TileTank && (tank = (TileTank)tile).getClientRenderFluid() != null) {
            return tank.getClientRenderFluid().getLuminosity();
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSideIcon() {
        return this.iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBottomIcon() {
        return this.iconBottom;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTopIcon() {
        return this.iconTop;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return WorldHelper.getBlockAt((IBlockAccess)worldIn, (BlockPos)pos.func_177972_a(side)) != this;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileTank te = (TileTank)world.func_175625_s(pos);
        Map<EnumFacing, TileTank.Mode> settings = te.getSettings();
        TileTank.Mode north = settings.get(EnumFacing.NORTH);
        TileTank.Mode south = settings.get(EnumFacing.SOUTH);
        TileTank.Mode west = settings.get(EnumFacing.WEST);
        TileTank.Mode east = settings.get(EnumFacing.EAST);
        TileTank.Mode down = settings.get(EnumFacing.DOWN);
        TileTank.Mode up = settings.get(EnumFacing.UP);
        return state.func_177226_a(NORTH, (Comparable)((Object)north)).func_177226_a(SOUTH, (Comparable)((Object)south)).func_177226_a(WEST, (Comparable)((Object)west)).func_177226_a(EAST, (Comparable)((Object)east)).func_177226_a(UP, (Comparable)((Object)up)).func_177226_a(DOWN, (Comparable)((Object)down)).func_177226_a((IProperty)DUMMY_RCL, (Comparable)Integer.valueOf(0));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN, DUMMY_RCL});
    }

    @SideOnly(value=Side.CLIENT)
    public void registerTextures(IIconRegistrar iIconRegistrar) {
        this.iconSide = iIconRegistrar.registerSprite((ResourceLocation)new DRResourceLocation("blocks/tankside"));
        this.iconTop = iIconRegistrar.registerSprite((ResourceLocation)new DRResourceLocation("blocks/tanktop"));
        this.iconBottom = iIconRegistrar.registerSprite((ResourceLocation)new DRResourceLocation("blocks/tankbottom"));
    }
}

