/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance;

import elec332.core.api.network.INetworkHandler;
import elec332.core.api.network.ModNetworkHandler;
import elec332.core.config.ConfigWrapper;
import elec332.core.main.ElecCoreRegistrar;
import elec332.core.util.LoadTimer;
import java.io.File;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.commands.CommandDRGen;
import mcjty.deepresonance.compat.CompatHandler;
import mcjty.deepresonance.compat.handlers.ComputerCraftCompatHandler;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.generatornetwork.DRGeneratorNetwork;
import mcjty.deepresonance.integration.computers.OpenComputersIntegration;
import mcjty.deepresonance.items.manual.GuiDeepResonanceManual;
import mcjty.deepresonance.proxy.CommonProxy;
import mcjty.deepresonance.radiation.DRRadiationManager;
import mcjty.deepresonance.tanks.TankGridHandler;
import mcjty.lib.base.ModBase;
import mcjty.lib.compat.CompatCreativeTabs;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="deepresonance", name="DeepResonance", dependencies="required-after:mcjtylib_ng@[2.3.0,);required-after:compatlayer@[0.2.6,);required-after:eleccore@[1.6.345,);after:Forge@[12.18.1.2082,);after:forge@[13.19.0.2176,);after:OpenComputers@[1.6.0,)", version="1.4.8", acceptedMinecraftVersions="[1.10,1.12)")
public class DeepResonance
implements ModBase {
    public static final String MODID = "deepresonance";
    public static final String VERSION = "1.4.8";
    public static final String MIN_ELECCORE_VER = "1.6.345";
    public static final String MIN_OPENCOMPUTERS_VER = "1.6.0";
    public static final String MIN_FORGE10_VER = "12.18.1.2082";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    public static final String MIN_MCJTYLIB_VER = "2.3.0";
    public static final String COMPATLAYER_VER = "0.2.6";
    @SidedProxy(clientSide="mcjty.deepresonance.proxy.ClientProxy", serverSide="mcjty.deepresonance.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="deepresonance")
    public static DeepResonance instance;
    public static Logger logger;
    public static File mainConfigDir;
    public static File modConfigDir;
    public static Configuration config;
    public static Configuration versionConfig;
    public static CompatHandler compatHandler;
    public static ConfigWrapper configWrapper;
    @ModNetworkHandler
    public static INetworkHandler networkHandler;
    private static LoadTimer loadTimer;
    public boolean rftools = false;
    public boolean rftoolsControl = false;
    public static CreativeTabs tabDeepResonance;
    private static final int CONFIG_VERSION = 1;

    public DeepResonance() {
        FluidRegistry.enableUniversalBucket();
    }

    private boolean readVersionConfig() {
        int oldVersion = -1;
        try {
            Configuration cfg = versionConfig;
            cfg.load();
            oldVersion = cfg.get("version", "version", -1).getInt();
            cfg.getCategory("version").remove((Object)"version");
            cfg.get("version", "version", 1).getInt();
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        return oldVersion != 1;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        loadTimer = new LoadTimer(logger, "DeepResonance");
        loadTimer.startPhase((FMLStateEvent)e);
        this.rftools = Loader.isModLoaded((String)"rftools");
        this.rftoolsControl = Loader.isModLoaded((String)"rftoolscontrol");
        mainConfigDir = e.getModConfigurationDirectory();
        modConfigDir = new File(mainConfigDir.getPath() + File.separator + MODID);
        versionConfig = new Configuration(new File(modConfigDir, "version.cfg"));
        config = new Configuration(new File(modConfigDir, "main.cfg"));
        File machinesFile = new File(modConfigDir, "machines.cfg");
        if (this.readVersionConfig()) {
            try {
                config.getConfigFile().delete();
                machinesFile.delete();
            }
            catch (Exception ee) {
                FMLLog.log((Level)Level.WARN, (Throwable)ee, (String)"Could not reset config file!", (Object[])new Object[0]);
            }
        }
        compatHandler = new CompatHandler(config, logger);
        compatHandler.addHandler(new ComputerCraftCompatHandler());
        configWrapper = new ConfigWrapper(new Configuration(machinesFile));
        configWrapper.registerConfigWithInnerClasses((Object)new ConfigMachines());
        configWrapper.refresh();
        proxy.preInit(e);
        ElecCoreRegistrar.GRIDHANDLERS.register((Object)new TankGridHandler());
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
        if (this.rftools) {
            Logging.log((String)"Detected RFTools: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftools", (String)"getScreenModuleRegistry", (String)"mcjty.deepresonance.items.rftoolsmodule.RFToolsSupport$GetScreenModuleRegistry");
        }
        if (this.rftoolsControl) {
            Logging.log((String)"Detected RFTools Control: enabling support");
            FMLInterModComms.sendFunctionMessage((String)"rftoolscontrol", (String)"getOpcodeRegistry", (String)"mcjty.deepresonance.compat.rftoolscontrol.RFToolsControlSupport$GetOpcodeRegistry");
        }
        loadTimer.endPhase((FMLStateEvent)e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDRGen());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        loadTimer.startPhase((FMLStateEvent)e);
        proxy.init(e);
        compatHandler.init();
        configWrapper.refresh();
        if (Loader.isModLoaded((String)"OpenComputers")) {
            OpenComputersIntegration.init();
        }
        loadTimer.endPhase((FMLStateEvent)e);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        Logging.log((String)"Deep Resonance: server is stopping. Shutting down gracefully");
        DRRadiationManager.clearInstance();
        DRGeneratorNetwork.clearInstance();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        loadTimer.startPhase((FMLStateEvent)e);
        proxy.postInit(e);
        loadTimer.endPhase((FMLStateEvent)e);
    }

    public String getModId() {
        return MODID;
    }

    public void openManual(EntityPlayer player, int bookIndex, String page) {
        GuiDeepResonanceManual.locatePage = page;
        player.openGui((Object)instance, bookIndex, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }

    static {
        tabDeepResonance = new CompatCreativeTabs("DeepResonance"){

            protected Item getItem() {
                return Item.func_150898_a((Block)ModBlocks.resonatingCrystalBlock);
            }
        };
    }
}

