/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import p455w0rdslib.LibRegistry;
import p455w0rdslib.P455w0rdsLib;
import p455w0rdslib.util.ProxiedUtils;

public class PlayerUtils {
    public static EntityPlayer getPlayerByContext(MessageContext ctx) {
        return P455w0rdsLib.PROXY.getPlayer(ctx);
    }

    public static void writeProfileToNBT(GameProfile profile, NBTTagCompound tag) {
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
    }

    public static GameProfile profileFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("Name");
        UUID uuid = null;
        if (tag.func_74764_b("UUIDL")) {
            uuid = new UUID(tag.func_74763_f("UUIDU"), tag.func_74763_f("UUIDL"));
        } else if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return new GameProfile(uuid, name);
    }

    public static NBTTagCompound proifleToNBT(GameProfile profile) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", profile.getName());
        UUID id = profile.getId();
        if (id != null) {
            tag.func_74772_a("UUIDL", id.getLeastSignificantBits());
            tag.func_74772_a("UUIDU", id.getMostSignificantBits());
        }
        return tag;
    }

    public static EntityPlayer getPlayerFromWorld(World world, UUID player) {
        if (player == null) {
            return null;
        }
        List players = world.field_73010_i;
        for (EntityPlayer entityPlayer : players) {
            if (entityPlayer.func_110124_au().compareTo(player) != 0) continue;
            return entityPlayer;
        }
        return null;
    }

    public static UUID getPlayerID(GameProfile profile) {
        return profile.getId();
    }

    public static GameProfile getPlayerProfile(GameProfile profile) {
        return profile;
    }

    public static boolean isOp(ICommandSender sender) {
        EntityPlayer player;
        if (!ProxiedUtils.isSMP()) {
            return true;
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            if (sender instanceof EntityPlayer) {
                EntityPlayer player2 = (EntityPlayer)sender;
                return player2.field_71075_bZ.field_75098_d || player2.func_175149_v();
            }
        } else if (FMLCommonHandler.instance().getSide() == Side.SERVER && sender instanceof EntityPlayerMP && (player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_())) != null && player.func_146103_bH() != null) {
            UserListOpsEntry userentry = (UserListOpsEntry)((EntityPlayerMP)player).field_71133_b.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
            return userentry != null && userentry.func_152644_a() >= 4;
        }
        if (sender instanceof TileEntityCommandBlock) {
            return true;
        }
        return sender.func_70005_c_().equalsIgnoreCase("@") || sender.func_70005_c_().equals("Server");
    }

    public static List<UUID> getFullPlayerList() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ArrayList uuidList = Lists.newArrayList();
        if (server != null) {
            String[] usernames;
            PlayerProfileCache playerCache = server.func_152358_ax();
            for (String username : usernames = server.func_71213_z()) {
                uuidList.add(playerCache.func_152655_a(username).getId());
            }
        }
        return uuidList;
    }

    public static ItemStack getPlayerSkull(String playerName) {
        ItemStack head = null;
        Map<String, ItemStack> skullCache = LibRegistry.getSkullRegistry();
        if (!skullCache.containsKey(playerName)) {
            head = new ItemStack(Items.field_151144_bL, 1, 3);
            NBTTagCompound nametag = new NBTTagCompound();
            nametag.func_74778_a("SkullOwner", playerName);
            head.func_77982_d(nametag);
            skullCache.put(playerName, head);
        }
        return skullCache.get(playerName);
    }
}

