/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnergyUtils {
    public static boolean isEnergyReceiverFromSide(TileEntity te, EnumFacing facing) {
        return te instanceof IEnergyReceiver ? ((IEnergyReceiver)te).canConnectEnergy(facing) : false;
    }

    public static ItemStack setFullPowerRF(ItemStack stack) {
        ItemStack fullItem = stack.func_77946_l();
        IEnergyContainerItem container = (IEnergyContainerItem)fullItem.func_77973_b();
        int total = container.getMaxEnergyStored(fullItem);
        while (container.getEnergyStored(fullItem) < container.getMaxEnergyStored(fullItem)) {
            container.receiveEnergy(fullItem, total, false);
        }
        return fullItem;
    }

    public static int getRF(IEnergyHandler handler) {
        if (handler != null) {
            return handler.getEnergyStored(EnumFacing.DOWN);
        }
        return 0;
    }

    public static int getRFCapacity(IEnergyHandler handler) {
        if (handler != null) {
            return handler.getMaxEnergyStored(EnumFacing.DOWN);
        }
        return 0;
    }

    public static IEnergyHandler getRFTile(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)te;
            return handler;
        }
        return null;
    }

    public static enum EnergyType {
        RF,
        Tesla,
        Forge,
        NONE;

    }
}

