/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerCape;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.client.render.LayerContributorWings;
import p455w0rdslib.util.DateUtils;
import p455w0rdslib.util.MCPrivateUtils;

@SideOnly(value=Side.CLIENT)
public class ContributorUtils {
    private static List<String> PATRON_LIST = new ArrayList<String>();
    public static Map<AbstractClientPlayer, LayerContributorWings.Type> REGISTRY = new LinkedHashMap<AbstractClientPlayer, LayerContributorWings.Type>();
    public static LayerContributorWings layerWings;

    public static void queuePlayerCosmetics(AbstractClientPlayer player) {
        LibGlobals.THREAD_POOL.submit(() -> {
            try {
                PATRON_LIST = ContributorUtils.getPatronList();
                if (PATRON_LIST.size() <= 0) {
                    return;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return;
            }
            Minecraft.func_71410_x().func_152344_a(() -> ContributorUtils.addCosmetic(player));
        });
    }

    private static void addCosmetic(AbstractClientPlayer player) {
        if (DateUtils.isXmas() || DateUtils.isXmasEve()) {
            ContributorUtils.addWings(LayerContributorWings.Type.XMAS);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.XMAS);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
        if (ContributorUtils.doesPlayerHaveEmeraldWings(player)) {
            ContributorUtils.addWings(LayerContributorWings.Type.EMERALD);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.EMERALD);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
        if (ContributorUtils.doesPlayerHaveBloodWings(player)) {
            ContributorUtils.addWings(LayerContributorWings.Type.BLOOD);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.BLOOD);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
        if (ContributorUtils.doesPlayerHaveBlueWings(player)) {
            ContributorUtils.addWings(LayerContributorWings.Type.BLUE);
            ContributorUtils.registerContributor(player, LayerContributorWings.Type.BLUE);
            LibGlobals.IS_CONTRIBUTOR = true;
            return;
        }
    }

    public static void registerContributor(AbstractClientPlayer player, LayerContributorWings.Type type) {
        if (player != null && type != null && !REGISTRY.containsKey(player)) {
            REGISTRY.put(player, type);
        }
    }

    public static boolean isContributor(AbstractClientPlayer player) {
        return player != null && REGISTRY.containsKey(player);
    }

    public static LayerContributorWings.Type getWingType(AbstractClientPlayer player) {
        if (player != null && REGISTRY.containsKey(player)) {
            return REGISTRY.get(player);
        }
        return null;
    }

    public static void addWings(LayerContributorWings.Type type) {
        for (RenderPlayer renderPlayer : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            List<LayerRenderer<AbstractClientPlayer>> r = MCPrivateUtils.getLayerRenderers(renderPlayer);
            for (int i = 0; i < r.size(); ++i) {
                if (!(r.get(i) instanceof LayerElytra) && !(r.get(i) instanceof LayerCape)) continue;
                renderPlayer.func_177089_b(r.get(i));
            }
            layerWings = new LayerContributorWings();
            renderPlayer.func_177094_a((LayerRenderer)layerWings);
        }
    }

    static List<String> getPatronList() {
        try {
            List<String> entries = new ArrayList();
            HttpURLConnection con = (HttpURLConnection)new URL("http://p455w0rd.net/mc/patrons.txt").openConnection();
            con.setConnectTimeout(1000);
            InputStream in2 = con.getInputStream();
            entries = IOUtils.readLines((InputStream)in2);
            if (!entries.isEmpty()) {
                con.disconnect();
                return entries;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static boolean doesPlayerHaveEmeraldWings(AbstractClientPlayer player) {
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            String uuid = player.func_110124_au().toString() + "_EWINGS";
            if (!uuid.equals(PATRON_LIST.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean doesPlayerHaveBloodWings(AbstractClientPlayer player) {
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            String uuid = player.func_110124_au().toString() + "_RWINGS";
            if (!uuid.equals(PATRON_LIST.get(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean doesPlayerHaveBlueWings(AbstractClientPlayer player) {
        for (int i = 0; i < PATRON_LIST.size(); ++i) {
            String uuid = player.func_110124_au().toString() + "_BWINGS";
            if (!uuid.equals(PATRON_LIST.get(i))) continue;
            return true;
        }
        return false;
    }
}

