/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mods.tconstruct.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.mc1102.item.MCItemStack;
import modtweaker.JEIAddonPlugin;
import modtweaker.mods.tconstruct.TConstructHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.plugin.jei.CastingRecipeWrapper;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.tconstruct.Casting")
public class Casting {
    protected static final String name = "TConstruct Casting";

    @ZenMethod
    public static void addBasinRecipe(IItemStack output, ILiquidStack liquid, @Optional IItemStack cast, @Optional boolean consumeCast, @Optional int timeInTicks) {
        if (liquid == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        RecipeMatch match = null;
        if (cast != null) {
            match = RecipeMatch.of((ItemStack)InputHelper.toStack((IItemStack)cast));
        }
        FluidStack fluid = InputHelper.toFluid((ILiquidStack)liquid);
        if (timeInTicks == 0) {
            timeInTicks = CastingRecipe.calcCooldownTime((Fluid)fluid.getFluid(), (int)fluid.amount);
        }
        CastingRecipe rec = new CastingRecipe(InputHelper.toStack((IItemStack)output), match, fluid, timeInTicks, consumeCast, false);
        MineTweakerAPI.apply((IUndoableAction)new Add(rec, (LinkedList)TConstructHelper.basinCasting, false));
    }

    @ZenMethod
    public static void addTableRecipe(IItemStack output, ILiquidStack liquid, @Optional IItemStack cast, @Optional boolean consumeCast, @Optional int timeInTicks) {
        if (liquid == null || output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        RecipeMatch match = null;
        if (cast != null) {
            match = RecipeMatch.of((ItemStack)InputHelper.toStack((IItemStack)cast));
        }
        FluidStack fluid = InputHelper.toFluid((ILiquidStack)liquid);
        if (timeInTicks == 0) {
            timeInTicks = CastingRecipe.calcCooldownTime((Fluid)fluid.getFluid(), (int)fluid.amount);
        }
        CastingRecipe rec = new CastingRecipe(InputHelper.toStack((IItemStack)output), match, fluid, timeInTicks, consumeCast, false);
        MineTweakerAPI.apply((IUndoableAction)new Add(rec, (LinkedList)TConstructHelper.tableCasting, true));
    }

    @ZenMethod
    public static void removeTableRecipe(IIngredient output, @Optional IIngredient liquid, @Optional IIngredient cast) {
        Casting.removeRecipe(output, liquid, cast, TConstructHelper.tableCasting, true);
    }

    @ZenMethod
    public static void removeBasinRecipe(IIngredient output, @Optional IIngredient liquid, @Optional IIngredient cast) {
        Casting.removeRecipe(output, liquid, cast, TConstructHelper.basinCasting, false);
    }

    public static void removeRecipe(IIngredient output, IIngredient liquid, IIngredient cast, List<ICastingRecipe> list, boolean table) {
        if (output == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (liquid == null) {
            liquid = IngredientAny.INSTANCE;
        }
        LinkedList<ICastingRecipe> recipes = new LinkedList<ICastingRecipe>();
        for (ICastingRecipe recipe : list) {
            if (!(recipe instanceof CastingRecipe) || ((CastingRecipe)recipe).getResult() == null || !StackHelper.matches((IIngredient)output, (IItemStack)InputHelper.toIItemStack((ItemStack)((CastingRecipe)recipe).getResult())) || !StackHelper.matches((IIngredient)liquid, (ILiquidStack)InputHelper.toILiquidStack((FluidStack)((CastingRecipe)recipe).getFluid())) || ((CastingRecipe)recipe).cast != null && cast != null && ((CastingRecipe)recipe).cast.matches(InputHelper.toStacks((IItemStack[])cast.getItems().toArray(new IItemStack[0]))) == null) continue;
            recipes.add((ICastingRecipe)((CastingRecipe)recipe));
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes, table));
        } else {
            LogHelper.logWarning((String)String.format("No %s Recipe found for output %s, material %s and cast %s. Command ignored!", name, output.toString(), liquid.toString(), cast != null ? cast.toString() : null));
        }
    }

    private static class Remove
    extends BaseListRemoval<ICastingRecipe> {
        final boolean table;

        public Remove(List<ICastingRecipe> list, List<ICastingRecipe> recipes, boolean table) {
            super(Casting.name, list, recipes);
            this.table = table;
        }

        protected String getRecipeInfo(ICastingRecipe recipe) {
            return LogHelper.getStackDescription((Object)((CastingRecipe)recipe).getResult());
        }

        /*
         * Unable to fully structure code
         */
        public IRecipeWrapper wrapRecipe(ICastingRecipe recipe) {
            if (JEIAddonPlugin.recipeRegistry != null && ((CastingRecipe)recipe).getResult() != null) {
                focus = JEIAddonPlugin.recipeRegistry.createFocus(IFocus.Mode.OUTPUT, (Object)((CastingRecipe)recipe).getResult());
                categories = JEIAddonPlugin.recipeRegistry.getRecipeCategories(focus);
                var4 = categories.iterator();
                block0: while (true) {
                    if (!var4.hasNext()) {
                        if (this.table) {
                            return new CastingRecipeWrapper((CastingRecipe)recipe, JEIAddonPlugin.castingTable);
                        }
                        return new CastingRecipeWrapper((CastingRecipe)recipe, JEIAddonPlugin.castingBasin);
                    }
                    category = (IRecipeCategory)var4.next();
                    if (!category.getUid().equals("tconstruct.casting_table")) continue;
                    wrappers = JEIAddonPlugin.recipeRegistry.getRecipeWrappers(category, focus);
                    var7 = wrappers.iterator();
                    do {
                        if (var7.hasNext()) ** break;
                        continue block0;
                    } while (!StackHelper.matches((IIngredient)new MCItemStack((ItemStack)(wrapper = (CastingRecipeWrapper)var7.next()).lazyInitOutput().get(0)), (IItemStack)new MCItemStack(((CastingRecipe)recipe).getResult())));
                    break;
                }
                return wrapper;
            }
            return null;
        }
    }

    private static class Add
    extends BaseListAddition<ICastingRecipe> {
        final boolean table;

        public Add(CastingRecipe recipe, LinkedList<ICastingRecipe> list, boolean table) {
            super(Casting.name, list);
            this.recipes.add(recipe);
            this.table = table;
        }

        protected String getRecipeInfo(ICastingRecipe recipe) {
            return LogHelper.getStackDescription((Object)((CastingRecipe)recipe).getResult());
        }

        public IRecipeWrapper wrapRecipe(ICastingRecipe recipe) {
            if (this.table) {
                return new CastingRecipeWrapper((CastingRecipe)recipe, JEIAddonPlugin.castingTable);
            }
            return new CastingRecipeWrapper((CastingRecipe)recipe, JEIAddonPlugin.castingBasin);
        }
    }
}

